import React, { PureComponent } from 'react'
import { Tag } from '../../../common'
import Course from '@/common/course-base'
import { http } from '@/utils'
import { Toast } from "antd-mobile";
import classnames from 'classnames'
import { isEmpty } from 'lodash'
import InfiniteScroll from "react-infinite-scroller";
import {HashLoader} from 'react-spinners'


import './free-courses.scss'

const Bottom = (props) => (
    <div className='bottom'>
        <Tag className={props.className}>{props.text}</Tag>
        <span>{props.audience}人观看</span>
    </div>
)

class FreeCourse extends PureComponent {

    page = 1
    num = 10
    state = {
        courses: [],
        live: [],
        page: 1,
        hasMore: false
    }

    componentDidMount() {
        this.getFreeCourses()
            .then(res => {
                let data = res.data
                if (data.code == 200) {
                    this.setState({
                        courses: data.data,
                        hasMore: true
                    })
                } else {
                    Toast.info(data.msg)
                }
            })
        this.getFreeLive()
            .then(res => {
                let data = res.data
                if (data.code == 200) {
                    this.setState({
                        live: isEmpty(data.data) ? [] : data.data
                    })
                } else {
                    Toast.info(data.msg, 2, null, false)
                }
            })
    }

    handleClick = id => {
        this.props.history.push(`/play/video?id=${id}`)
    }

    getFreeCourses = () => {
        return http.get(`${API.home}/m/free_course/${this.page++}/${this.num}`)
    }

    getFreeLive = () => {
        return http.get(`${API.home}/m/live/free_list`)
    }

    toLive = live => {
        const {room_id, live_status} = live
        if (live_status) {
            window.location.assign(`http://www.julyedu.com/live/m_room/${room_id}`)
        } else {
            Toast.info('直播即将开始，敬请期待', 2, null, false)
        }
    }

    loadFunc = () => {
        if (this.state.hasMore) {
            this.setState({
                hasMore: this.state.courses.length % 10 === 0
            }, () => {
                this.getFreeCourses()
                    .then(res => {
                        let data = res.data
                        if (data.code == 200) {
                            Array.isArray(data.data) && this.setState({
                                courses: this.state.courses.concat(data.data),
                                hasMore: data.data.length % 10 === 0
                            })
                        } else {
                            Toast.info(data.msg)
                        }
                    })
            })
        }
    }

    render() {
        return (
            <InfiniteScroll
                pageStart={0}
                loadMore={this.loadFunc}
                useWindow={false}
                className={'free-courses'}
                element={'ul'}
                hasMore={this.state.hasMore}
                threshold={250}
            >
                {
                    this.state.live.map((item, index) => {
                        const Bottom = (
                            <div className="bottom">
                                <div className="animation-box">
                                    {new Array(4).fill('a').map((item, index) => {
                                        return <i key={index} className={classnames('column', `column-${index + 1}`)}/>
                                    })}
                                </div>
                                <div className="time">{`${item['live_start_time']}`}</div>
                            </div>
                        )

                        const LiveStatus = (
                            item['live_status'] == 0 ? <Tag className={'tag-soon top'}>即将开始</Tag> :
                                <Tag className={'tag-playing top'}>正在直播</Tag>
                        )
                        return (
                            <Course
                                img={item['live_cover']}
                                title={item['live_title']}
                                top={LiveStatus}
                                bottom={Bottom}
                                key={item['live_id']}
                                className={'live'}
                                handleClick={this.toLive.bind(this, item)}
                                id={index}
                            />
                        )
                    })
                }
                {
                    this.state.courses.map((item, index) => (
                        <Course
                            img={item.logo}
                            title={item['video_course_name']}
                            handleClick={this.handleClick}
                            bottom={
                                <Bottom audience={item['play_times']} className={'tag-category'} text={item.category}/>
                            }
                            id={item['v_course_id']}
                            key={index}
                            className={'course-item'}
                        />
                    ))
                }
            </InfiniteScroll>
        )
    }
}


export default FreeCourse