import React, { Component } from 'react'
import { http } from "@/utils"
import './prizes.scss'
import { Popup } from "@common/index"
import { Toast } from "antd-mobile"


import Loadable from '@loadable/component'

const SystemBulletScreen = Loadable(() => import(/* webpackChunkName: 'system-notices' */'@components/activity/newyear-2019/common/system-bullet-screen'))

class Prizes extends Component {

  prizeBox
  prizeList
  bg
  innerBox
  closeIcon = 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/close-btn.png'

  state = {
    prizes: [],
    notices: [],
    rule: [],
    unfoldList: false,
  }

  componentDidMount() {
    this.getPrizes()
  }

  getPrizes = () => {
    http.get(`${API.home}/sys/prize_data`)
      .then(res => {
        const {code, data, msg} = res.data
        if (code == 200) {

          this.setState({
            prizes: data['prize_data'],
            notices: data['notices'],
            rule: data['rule']
          })

        } else {
          Toast.info(msg, 2, null, false)
        }
      })
  }


  showRules = () => {
    Popup({
      title: '组队开宝箱活动规则',
      className: 'landing-treasure-rules',
      content: <div dangerouslySetInnerHTML={{__html: this.state.rule}}/>,
      closeIcon: this.closeIcon
    })
  }


  showMore = () => {
    this.setState(prev => {
      if (this.state.unfoldList) {
        this.bg.style = this.innerBox.style = this.prizeBox.style = ''
      } else {
        let headHeight = parseFloat(getComputedStyle(this.prizeBox, ':before').getPropertyValue('height')),
          footerHeight = parseFloat(getComputedStyle(this.prizeBox, ':after').getPropertyValue('height')),
          innerOffsetTop = 0.12458,
          footerOffsetTop = 0.595,
          h = this.prizeList.scrollHeight,
          scrollListHeight = headHeight + h - (innerOffsetTop * headHeight) - (footerOffsetTop * footerHeight) + footerHeight,
          bottomOffset = 27

        this.prizeBox.style.height = `${scrollListHeight + bottomOffset}px`
        this.innerBox.style.height = `${h}px`
        this.bg.style.height = `${h - footerHeight + innerOffsetTop * headHeight + bottomOffset}px`
      }
      return {unfoldList: !prev.unfoldList}
    })

  }

  render() {
    const {
      showSystemNotices
    } = this.props
    return (
      <>
        {showSystemNotices && <SystemBulletScreen bullets={this.state.notices}/>}
        <div className={'prizes-box'} ref={el => this.prizeBox = el}>
          <a href="javascript:;" className='rule-btn' onClick={this.showRules}>活动规则 > </a>
          <div className={`bg`} ref={el => this.bg = el}/>
          <div className={`inner-box`} ref={el => this.innerBox = el}>
            <ul className='prize-list' ref={el => this.prizeList = el}>
              {
                this.state.prizes.map((item, index) => {
                  return (
                    <li key={index}>
                      <img src={item.img_name} alt=""/>
                      {
                        item.is_captain != 0 && <span className='captain top-tag'>队长专属</span>
                      }
                      {
                        item.mode === 2 && <span className='stage top-tag'>第{item.stage_no}次必中</span>
                      }
                      {
                        item.grant_max
                          ?
                          <div className='bottom-bar'>
                            <div className="progress-bar"><span className={'progress'}/></div>
                            <span>限量{item.grant_max}份</span>
                          </div>
                          : <span className='no-limit'>不限量</span>
                      }
                    </li>
                  )
                })
              }
              <li>
                <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/prize-placeholder.png" alt=""/>
              </li>
            </ul>
          </div>
          <div className="show-more" onClick={this.showMore}>
            {
              this.state.unfoldList
                ? <div>
                  收起
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/fold-icon.png" alt=""/>
                </div>
                : <div>
                  查看全部奖品
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/unfold-icon.png" alt=""/>
                </div>
            }
          </div>
        </div>
      </>
    )
  }
}

export default Prizes
