import React, { Component } from 'react';
import './index.scss';

export default class index extends Component {
  constructor(props) {
    super(props);
  }
  computedStyle = () => {
    return {
      'top': `${this.props.top}px`,
      'width': `${this.props.width}px`
    }
  }

  // 控制点击空白处是否关闭弹窗 需要传递一个boolean属性 mark
  closePopup = () => {
    if(this.props.mark) {
      this.props.closePopup();
    }
  }

  render() {
    return (
      <div className='popup__container' onClick={this.closePopup}>
        <div className='content__container' style={this.computedStyle()} onClick={(e) => {e.stopPropagation()}}>
          <img className="close__btn" onClick={this.props.closePopup} src='https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/close-btn.png' alt="" />
          {
            React.Children.map(this.props.children, function (child) {
              return <>{child}</>;
            })
          }
        </div>
      </div>
    )
  }
}
