import React, { Component } from 'react';
import { Toast } from 'antd-mobile';
import { http } from '@/utils';
import './index.scss';

class ConfirmPhone extends Component {
  continueBindPhone = () => {
    const { data, successBindPhone } = this.props;
    http.post(
      `${API.home}/sys/v2/user/bindMobile`,
      {  
        ...data,
        type: 1, // 1：绑定，2：修改绑定
        is_valid: 0, // is_valid	是否验证 1:验证（默认）,0不验证
      }
    ).then(res => {
      const { code, msg } = res.data;
      if(code === 200 ) {
        successBindPhone();
      }else {
        Toast.info(msg, 2, null, false);
      }
    });
  }

  render() {
    const { 
      bindInfo = { }, 
      desc, 
      skip = 'year', 
      handleToCancle 
    } = this.props;
    return (
      <div className="popup-bind" data-skip={skip}>
        <h2 className="popup-bind__title">绑定手机号</h2>
        {
          desc
          ? <div className="popup-bind__desc">{desc}</div>
          : <p className="popup-bind__desc">该手机号已绑定到以下账号，继续绑定将解除以下绑定状态</p>
        }
        <ul className="popup-bind__list">
          {
            bindInfo['email'] &&
            <li className="popup-bind__account">

              {/* 邮箱 */}
              <i className="popup-bind__icon" data-plat="mail"></i>
              <p className="popup-bind__account--name">{bindInfo['email']}</p>
            </li>
          }
          {
            bindInfo['wechat_nickname'] &&
            <li className="popup-bind__account">

              {/* wechat */}
              <i className="popup-bind__icon" data-plat="wachat"></i>
              <p className="popup-bind__account--name">{bindInfo['wechat_nickname']}</p>
            </li>
          }
          {
            bindInfo['qq_nickname'] &&
            <li className="popup-bind__account">

              {/* qq */}
              <i className="popup-bind__icon" data-plat="qq"></i>
              <p className="popup-bind__account--name">{bindInfo['qq_nickname']}</p>
            </li>
          }
          {
            bindInfo['sina_nickname'] &&
            <li className="popup-bind__account">

              {/* 微博 */}
              <i className="popup-bind__icon" data-plat="sina"></i>
              <p className="popup-bind__account--name">{bindInfo['sina_nickname']}</p>
            </li>
          }
        </ul>
        <div className="popup-bind__footer">
          <button
          className="popup-bind__button popup-bind__button--cancle"
          onClick={handleToCancle}>取消</button>
          <button
          className="popup-bind__button popup-bind__button--confirm"
          onClick={this.continueBindPhone}>继续绑定</button>
        </div>
      </div>
    )
  }
}

export default ConfirmPhone;