import React, { Component } from 'react';
import { http } from '@/utils';
import './rank.scss'

class TreasureRank extends Component {

  constructor(props) {
    super(props);
    this.state = {
      rank: [],
      rankList: [],
      isMore: false,
    }
  }

  componentDidMount() {
    this.fetchRankInfo();
  }

  fetchRankInfo = () => {
    http.get(`${API.home}/sys/treasure/ranking`).then(res => {
      const { code, data } = res.data;
      if(code === 200) {
        if(JSON.stringify(data) !== '{}') {
          if(data.length > 5) {
            this.setState({
              rank: data.filter((item, index) => index < 5),
              rankList: data,
              isMore: true,
            });
          }else {
            this.setState({
              rank: data,
              rankList: data,
              isMore: false,
            });
          }
        }
      }
    });
  }

  switchMoreRank = () => {
    const { rankList, isMore } = this.state;
    if(isMore) {
      this.setState({
        rank: rankList,
        isMore: false,
      })
    }else {
      this.setState({
        rank: rankList.filter((item, index) => index < 5),
        isMore: true,
      })
    }
  }

  render() {
    const { rank, isMore } = this.state;
    return (
      <>
        {
          rank.length !== 0 &&
          <div data-skip="rank">
            <div className="rank-title">
              <i className="rank-title__decorate"></i>
              <h2 className="rank-title__txt">宝箱达人榜</h2>
              <i className="rank-title__decorate"></i>
            </div>
            <p className="rank-desc">宝箱数量前50名可额外获得一份奖品，数量相同的用时短者排名在前</p>
            <dl className="rank-header">
              <dd className="rank-column">排名</dd>
              <dd className="rank-column">用户</dd>
              <dd className="rank-column">宝箱数量</dd>
              <dd className="rank-column">奖品</dd>
            </dl>
            <div className="rank-body">
              {
                rank.map((item, index) => (
                  <dl className="rank-item" key={index}>
                    <dd className="rank-column">
                      {
                        index <= 2
                        ? <span className="rank-column__number" data-num={index}></span>
                        : <span>{index+1}</span>
                      }
                    </dd>
                    <dd className="rank-column">
                      <span className="rank-column__name">{item.user_name}</span>
                    </dd>
                    <dd className="rank-column">
                      <span>{item.num}</span>
                    </dd>
                    <dd className="rank-column">
                      {
                        item.url
                        ? <a className="rank-column__txt" href={item.url}>{item.prize_name}</a>
                        : <span className="rank-column__txt">{item.prize_name}</span>
                      }
                    </dd>
                  </dl>
                ))
              }
              <div className="rank-more" onClick={this.switchMoreRank}>
                <span className="rank-more__txt">{isMore? '展开' : '收起'}</span>
                <i className="rank-more__icon" data-more={isMore}></i>
              </div>
            </div>
          </div>
        }
      </>
    )
  }
}

export default TreasureRank;