import React, {Component} from 'react'
import {VList} from '../../common'
import {Tabs, WhiteSpace, Toast} from 'antd-mobile'
import './index.scss'
import HeaderSearch from '../../common/HeaderSearch/index'
import {http} from "@/utils"
import Loading from '@/common/Loading'
import {connect} from 'react-redux';

@connect(({user}) => ({
    user
}))
class Preferential extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataList: [],
            courseStatus: 0,
            isLoading: true
        }
    }

    componentDidMount() {
        this.specialSale()
    }

    // 限时特惠
    specialSale = () => {
        http.get(`${API.home}/m/home/weekDiscounts`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    dataList: res.data.data,
                    isLoading: false
                })
            } else {
                Toast.info(res.data.msg, 2)
            }

        })
    }
    // 砍价专区
    bargain = () => {
        http.get(`${API.home}/m/home/bargainZone`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    dataList: JSON.stringify(res.data.data) == '{}' ? []:res.data.data,
                    isLoading: false,
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }
    // 一键拼团
    group = () => {
        http.get(`${API.home}/m/home/grouponList`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    dataList: res.data.data,
                    isLoading: false,
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }
    // tab 切换
    ontabclick = (tab, index) => {
        this.setState({
            courseStatus: index,
            isLoading: true,
        })
        switch (index) {
            case 0:
                this.specialSale()
                break
            case 1:
                this.bargain()
                break
            default:
                this.group()
        }
    }

    toCourseDetail = (id) => {
        const {dispatch, history} = this.props;
        // dispatch(getCourses(id, () => {
        history.push(`/detail?id=${id}`)
        // }));
    }

    render() {
        const tabs = [
            {title: '限时特惠'},
            {title: '砍价专区'},
            {title: '一键拼团'}
        ]
        const {user = {}} = this.props;
        let isLogin = user.data && user.data.uid ? true : false;
        return (
            <div className='preferential'>
                <HeaderSearch isLogin={isLogin}/>
                <Loading isLoading={this.state.isLoading}>
                    <div className='class-content'>
                        <WhiteSpace/>

                        <Tabs
                            tabs={tabs}
                            animated={false}
                            onChange={(tab, index) => this.ontabclick(tab, index)}
                            swipeable={false}
                            page={this.state.courseStatus}
                            renderTabBar={props => <div className={'custom-tab-bar'}>
                                <Tabs.DefaultTabBar {...props}/>
                            </div>}
                        >
                        </Tabs>
                        <div className='tabs'>
                            {
                                this.state.dataList.length>0?
                                <ul>
                                    {this.state.dataList.map((item, index) => {
                                        const Info = (
                                            <div className="info">
                                                <p className='title'
                                                   onClick={() => this.toCourseDetail(item.course_id)}>
                                                    {/* <Link to={`/detail?id=${item.course_id}`}> */}
                                                    {item.course_title}
                                                    {/* </Link> */}
                                                </p>
                                                <p className='contact text-overflow-2'>{item.course_desc}</p>
                                                <div className='des'>
                                                    {!item.is_buy &&
                                                    <p className="course-price">
                                                        {this.state.courseStatus === 0 &&
                                                        <span className='price'>特惠价：</span>
                                                        }
                                                        <span className="new">¥{item.price1}</span>
                                                        <span className="old">¥{item.price0}</span>
                                                    </p>
                                                    }
                                                    {item.is_buy &&
                                                    <a className="isbuy">已购买</a>
                                                    }
                                                </div>
                                            </div>
                                        )
                                        const status = (
                                            !item.is_buy &&
                                            <div>
                                                {this.state.courseStatus === 1 &&
                                                <p className='course-status'>砍价减{item.bargain_price}元</p>
                                                }
                                                {this.state.courseStatus === 2 &&
                                                <p className='course-status'>拼团价{item.price}元</p>
                                                }
                                                {
                                                    item.is_aist && <span className='return_cash'></span>
                                                }
                                            </div>
                                        )
                                        return (
                                            <VList
                                                key={index}
                                                img={item.image_name}
                                                id={item.course_id}
                                                status={status}
                                                info={Info}
                                                toDetail={this.toCourseDetail}
                                            />
                                        )
                                    })}
                                </ul>:<div className={'notdata'}>砍价的课程已被设置为双十一活动课程，参加双十一活动购买课程优惠更多哦！</div>
                            }

                        </div>
                        <WhiteSpace/>
                    </div>
                </Loading>
            </div>
        )
    }

}

export default Preferential;
