import React, { Component } from 'react'
import './prizes.scss'
import { http } from "@/utils"
import { Toast } from "antd-mobile"


function showToast(text) {
  Toast.info(text, 2, null, false)
}

class Prizes extends Component {

  state = {
    list: [
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-1.png',
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-2.png',
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-3.png',
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-4.png',
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-5.png',
      'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/prize-6.png',
    ],
    isShowRule: false,
    rankList: []
  }

  componentDidMount() {
    const {rankingList} = this.props
    console.log(rankingList)
    if (!rankingList || !rankingList.length) {
      this.getRankingList()
    } else {
      this.setState({
        rankingList
      })
    }
  }


  getRankingList = () => {
    const {saveRankingList} = this.props
    http.get(`${API["base-api"]}/assistance/ranking_list/50`)
      .then(res => {
        const {data, msg, errno} = res.data
        if (errno === 200) {

          this.setState({
            rankList: data.list
          })

          saveRankingList && saveRankingList(data.list)

        } else {
          showToast(msg)
        }
      })
  }

  render() {
    const {
      list,
      rankList,
      isShowRule
    } = this.state
    return (
      <div id={'prizes'}>
        <div className="content">
          <i className="part-title__decorate"/>
          <div className="part-title__txt">活动奖品</div>
          <i className="part-title__decorate"/>

          <div className="prize-img">
            {
              list.map((item, index) => {
                return (
                  <div className='img-box' key={index}>
                    <img src={item} alt=""/>
                  </div>
                )
              })
            }
          </div>

          <span className="rule" onClick={() => {
            this.setState({isShowRule: true})
          }}>活动规则</span>
        </div>

        <div className="content" style={{padding: `20px 0 30px 0`}}>
          <i className="part-title__decorate"/>
          <div className="part-title__txt">排行榜</div>
          <i className="part-title__decorate"/>

          <div className="tip">
            数据实时更新 只显示Top50
          </div>

          <table className="ranking" cellSpacing="0" cellPadding="0" border="0">
            <thead>
            <tr>
              <td>排名</td>
              <td>用户名称</td>
              <td>邀请人数</td>
            </tr>
            </thead>
            <tbody>
            {
              rankList.map((item, index) => {
                return (
                  <tr key={index}>
                    <td>{index + 1}</td>
                    <td>{item.name}</td>
                    <td>{item.num}</td>
                  </tr>
                )
              })
            }
            </tbody>
          </table>
        </div>

        {
          isShowRule ?
            <div className="mbc-box">
              <div className="rele-content">
                <div className="title">活动规则</div>
                <p>1、进入七月在线服务号<a
                  style={{fontSize: `16px`, color: `rgba(47, 248, 255, 1)`, display: `inline-block`}}>回复77</a>获取活动海报，将上方课程赠送给好友，每有1名好友领取后，您和好友均可免费学习1课时该课；
                </p>
                <p>2、每多1名好友领取，您获得的课时数+1，直到获得全部课时，届时仍可赠送给好友；</p>
                <p>3、活动结束后，邀请好友数超过50人且排行榜前20名用户会得到<a
                  style={{fontSize: `16px`, color: `rgba(47, 248, 255, 1)`, display: `inline-block`}}>19VIP年会员、樱桃键盘</a>等大奖。
                </p>
              </div>
              <img className="close"
                   onClick={() => {this.setState({isShowRule: false})}}
                   src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/close-btn.png" alt=""/>
            </div>
            : null
        }


      </div>
    )
  }
}

export default Prizes
