import React, { PureComponent } from 'react';
import SearchHeader from './searchHead'
import VList from '@/common/VList'
import { http, getParam } from '@/utils'
import './search-result.scss'
import Recommendation from './recommendation'
import throttle from 'lodash/throttle'


const ForwardRefSearchHead = React.forwardRef((props, ref) => {
    return <SearchHeader {...props} forwardedRef={ref}/>
})

const Bottom = ({item}) => {
    return (
        <div className='bottom'>
            <span className='price'>¥{item.price1}</span>
            <span className='stale-price'>¥{item.price0}</span>
        </div>
    )
}

class SearchResult extends PureComponent {
    prevScrollY = 0
    searchHead = React.createRef()
    swipeUp = 'up'
    swipeDown = 'down'

    state = {
        courseList: [],
        value: decodeURIComponent(getParam('word')) || '',
        searchHistory: JSON.parse(localStorage.getItem('searchHistory')) || [],
        fixedHeader: false,
        searchHeadStyle: {top: 0},
        swipeDirection: this.swipeUp,
        isHide: false,
        basicTop: 0
    }

    componentDidMount() {
        this.getCourses(getParam('word'))
        document.addEventListener('scroll', this.handleScroll)
    }

    componentWillUnmount() {
        document.removeEventListener('scroll', this.handleScroll)
    }


    getCourses = (word) => {
        http.get(`${API['search-api']}/search/${word}?type=course&page=1`)
            .then(res => {
                const data = res.data

                if (data.errno === 0) {
                    this.setState({
                        courseList: data.data.info['search_data'].course
                    });
                }
            })
    }

    handleClick = id => {
        this.props.history.push(`/detail?id=${id}`)
    }

    handleSearch = () => {
        this.state.value && this.getCourses(this.state.value)
    }

    handleChange = value => {
        this.setState({value})
    }

    toCourseDetail = (id) => {
        const {history} = this.props;
        history.push(`/detail?id=${id}`)
    }

    handleScroll = throttle(() => {
        let y = window.scrollY < 0? 0 : window.scrollY,
            headY = this.searchHead.current.offsetTop,
            h = this.searchHead.current.offsetHeight;
        if(y > this.prevScrollY) {
            this.setState({
                searchHeadStyle: {
                    top : `${-h}px`
                }
            });
        }
        if(y < this.prevScrollY) {
            this.setState({
                searchHeadStyle: {
                    top: 0
                }
            });
        }
        // if (y < this.prevScrollY) {
        //     if (this.state.swipeDirection === this.swipeDown) {
        //         y <= headY && this.state.searchHeadStyle.position !== 'fixed' &&
        //         this.setState({
        //             searchHeadStyle: {
        //                 top: `0`,
        //                 position: 'fixed'
        //             }
        //         })
        //     } else {
        //         this.setState({
        //             swipeDirection: this.swipeDown
        //         }, () => {
        //             if (this.state.swipeDirection === this.swipeDown) {
        //                 let h = y > document.querySelector('body').offsetHeight? document.querySelector('body').offsetHeight: y;
        //                 let h1 = this.searchHead.current.offsetHeight
        //                     this.setState({
        //                         searchHeadStyle: {
        //                             // top: `${h > headY ? h - h1 : h}px`
        //                             top: `${y}px`
        //                         }
        //                     })


        //             }
        //         })
        //     }
        // } else {
        //     this.state.swipeDirection !== this.swipeUp &&
        //     this.setState({
        //         swipeDirection: this.swipeUp,
        //         searchHeadStyle: {
        //             position: 'absolute',
        //             top: `${y}px`
        //         }
        //     })
        // }
        this.prevScrollY = y;
    }, 0)

    render() {
        const { courseList, isHide } = this.state;

        return (
            <div
                className={'search-result'}>
                <ForwardRefSearchHead
                    handleSearch={this.handleSearch}
                    value={this.state.value}
                    handleChange={this.handleChange}
                    searchHistory={this.state.searchHistory}
                    style={this.state.searchHeadStyle}
                    ref={this.searchHead}
                    isHide={isHide}
                />
                {

                    courseList && courseList.length > 0 ?
                        <ul>
                            {
                                courseList.map(item => {
                                    const Info = (
                                        <div className="info">
                                            <p className='title'>{item.course_title}</p>
                                            <p className='des'>{item.simpledescription}</p>
                                            <Bottom
                                                item={item}
                                            />
                                        </div>
                                    )
                                    const status = (
                                        (item['bargain_num'] || item['groupon_num']) ?
                                            <div
                                                className='status'>
                                                {
                                                    item['bargain_num'] === 0 ? `砍价减${item['groupon_num']}元` : `拼团减${item['bargain_num']}元`
                                                }
                                            </div>
                                            : null
                                    )
                                    return (
                                        <VList
                                            img={item.image_name}
                                            toDetail={this.toCourseDetail}
                                            key={item.course_id}
                                            info={Info}
                                            id={item['course_id']}
                                            status={status}
                                        />
                                    )
                                })
                            }
                        </ul>
                        : <div className="empty">
                            <img src={require('./image/ss_empty.png')} alt=""/>
                            抱歉，没有搜到相关内容！
                        </div>
                }
                <Recommendation/>

            </div>
        );
    }
}


export default SearchResult;