import React from 'react';
import './index.scss'
import classnames from "classnames";


const Base = ({children, className}) => {
  return (
    <div className={classnames(['base-status-bar', className])}>
      {children}
    </div>
  );
};

const First = ({execute}) => {
  return <Base className={'first'}>
    <div className="tip">当前环境暂不支持编写程序，可前往PC端练习或点击按钮</div>
    <button className={'btn'} onClick={execute}>运行并查看结果</button>
  </Base>
}

const Normal = ({execute, checkAnswer, showAnswerButton = true}) => {
  return <Base className={'normal'}>
    {
      showAnswerButton && <button className={'check-answer'} onClick={checkAnswer}>查看参考答案</button>
    }
    <button className={'btn'} onClick={execute}>运行</button>
  </Base>
}

const Pass = () => {
  return <Base className={'pass'}>
    <i className={'iconfont icondanseshixintubiao-5'}></i>
    <span>运行通过</span>
  </Base>
}

const Error = ({showSkip = true}) => {
  return <Base className={'error'}>
    <div className="left">
      <i className="iconfont icondanseshixintubiao-3"></i>
      <span>第7行出现错误</span>
      {showSkip && <a href="javascript:void(0);">跳过本题</a>}
    </div>
    <button>查看答案</button>
  </Base>
}

const InputTip = () => {
  return <Base className={'input-tip'}>
    <div className="tip">输入完毕后请点击确认</div>
    <button>确认</button>
  </Base>
}

const Skipped = () => {
  return <Base className={'skipped complete'}>
    <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/interactive_tutorial/study/exclamation-mark.png" alt=""/>
    <div className="tip">已跳过课堂练习！</div>
    <a href="javascript:void(0);">重新运行</a>
  </Base>
}

const Finished = () => {
  return <Base className={'finished complete'}>
    <i className={'iconfont icondanseshixintubiao-5'}></i>
    <div className="tip">已跳过课堂练习！</div>
    <a href="javascript:void(0);">重新运行</a>
  </Base>
}

export default {
  First,
  Normal,
  Pass,
  Error,
  InputTip,
  Skipped,
  Finished
};