import React, { Component } from 'react';
import './index.scss'
import Container from './container'
import SingleAnswerQuestion from "@components/interactive-tutorial/single-answer-question"
import Program from "@components/interactive-tutorial/program"
import Project from './project'
import { getParam, http, getWXObject } from "@/utils"
import { Toast } from 'antd-mobile'
import { questionType, status } from './consts'
import Catalog from './catalog'


class InteractiveStudy extends Component {
  container = null
  state = {
    page: 1,
    progress: 0,
    schedule: {},
    pageData: {},
    cachedList: [],
    processContent: [],
    processStatus: status.resumePractice,
    isComplete: false,
    avatar: '',
    isFirst: true,
    isProgramShowed: 0,
    videoId: '',
  }

  componentDidMount() {
    this.getSchedule().then(res => {
      const {code, msg, data} = res.data
      if (code === 200) {
        const pageInfo = data.page_info
        const page = pageInfo.current_page
        this.setState({
          schedule: data,
          avatar: data.teacher_avatar,
          page,
          videoId: data.current_video_id,
        })
        document.title = data.current_video_name
        this.getPageContent(data.current_video_id, () => {
          this.updatePosition()
          this.getPageContent(data.current_video_id)
        })
      } else {
        this.showToast(msg)
      }
    })
  }

  getSchedule = () => {
    return http.post(`${API.home}/m/it/study/schedule`, {
      course_id: getParam('id'),
    })
  }

  updatePosition = () => {
    setTimeout(() => {
      window.scrollTo(0, this.container.scrollHeight)
    })
  }

  resetProcessStatus = () => {
    this.setState({
      processStatus: status.resumePractice,
    })
  }

  showToast = (msg, type = 'info') => {
    Toast[type](msg, 2, null, false)
  }

  getPageContent = (videoId, cb) => {
    const {page, schedule} = this.state
    if (page > schedule.page_info.total_pages) {
      return
    }
    http.post(`${API.home}/m/it/study/syllabus?page=${this.state.isFirst ? 1 : this.state.page}`, {
      course_id: getParam('id'),
      video_id: videoId,
      type: this.state.isFirst ? 1 : 2,
    }).then(res => {
      const {code, msg, data} = res.data
      if (code === 200) {
        this.setState(state => {
          const list = data.syllabus_list
          const progress = state.processContent.length
            ? list.findIndex(item => item.syllabus_id === state.processContent[state.processContent.length - 1].syllabus_id) + 1
            : 0
          if (state.isFirst) {
            return {
              processContent: state.processContent.concat(list),
              isFirst: false,
            }
          }
          return {
            cachedList: state.cachedList.reverse().concat(list.slice(progress)).reverse(),
            page: state.page + 1,
            pageData: data,
            progress: progress,
          }
        }, () => {
          cb && cb()
        })
      } else {
        this.showToast(msg)
      }
    })
  }

  saveSchedule = (syllabusId, unitInfoId) => {
    let data = {syllabus_id: syllabusId}
    if (unitInfoId) {
      data.unit_info_id = unitInfoId
    }
    http.post(`/m/it/user/saveSchedule`, data).then(res => {
      const {code, msg, data} = res.data
      if (code === 200) {

      } else {
        this.showToast(msg, 'fail')
      }
    })
  }

  savePractice = ({syllabusId, type, answer, result, lines}) => {
    let data = {
      syllabus_id: syllabusId,
      type,
      answer,
      result,
    }
    if (type === 2 && lines) {
      data.lines = lines
    }
    http.post(`${API.home}/m/it/user/savePractice`, data).then(res => {
      const {code, msg, data} = res.data
      if (code === 200) {

      } else {
        Toast.fail(msg, 2)
      }
    })
  }

  process = () => {
    const {processStatus} = this.state
    if (processStatus === status.practicingProgram || processStatus === status.practicingSingle) {
      this.showToast('有其他正在进行的练习')
      return
    }
    if (processStatus === status.nextSection) {
      console.log('下一关')
      return
    }
    this.setState(state => {
      let nextQuestion, cachedList = state.cachedList, pageData = state.pageData
      const length = cachedList.length
      if (length) {
        nextQuestion = [cachedList.pop()]
        if (length < 6) {
          this.getPageContent(state.videoId)
        }
      }
      if (!cachedList.length) {
        return {
          processStatus: status.nextSection,
        }
      }
      let processStatus = nextQuestion[0].type === questionType.singleAnswer
        ? status.practicingSingle
        : nextQuestion[0].type === questionType.program
          ? status.practicingProgram
          : status.resumePractice
      return {
        processContent: state.processContent.concat(nextQuestion),
        processStatus,
        isProgramShowed: processStatus === status.practicingProgram && (state.isProgramShowed + 1),
        cachedList,
        pageData,
      }
    }, () => {
      this.updatePosition()
    })
  }

  render() {
    const {processStatus, processContent, avatar, isProgramShowed} = this.state
    return (
      <div id={'interactive-study'} ref={el => this.container = el}>
        {
          !!processContent.length && processContent.map(item => {
            if (item.catalogue === 1) {
              switch (item.type) {
                case questionType.text:
                  return <Container user={avatar} content={item.content} key={item.syllabus_id}/>
                case questionType.image:
                  return <Container user={avatar} key={item.syllabus_id}>
                    <img src={item.content} alt=""/>
                  </Container>
                case questionType.singleAnswer:
                  return <SingleAnswerQuestion user={avatar} topic={item.content} question={item}
                                               key={item.syllabus_id} updatePosition={this.updatePosition}
                                               resetStatus={this.resetProcessStatus}/>
                case questionType.codeBlock:
                case questionType.program:
                  return <Program question={item} key={item.syllabus_id} isProgramShowed={isProgramShowed}/>
              }
            } else if (item.catalogue === 2) {
              return <Catalog title={item.content} key={item.syllabus_id}/>
            } else {
              return <Container key={item.syllabus_id}>
                <span className={'subtitle'}>{item.content}</span>
              </Container>
            }
          })
        }
        {
          processStatus === status.nextSection && <Project user={avatar}/>
        }
        <div className="status-bar" onClick={this.process}>
          {processStatus && <span className={'status'}>{processStatus}</span>}
          {/*<span className={'complete'}>已学完全部课时</span>*/}
          {/*<div className="free-trial-end">*/}
          {/*  <span>试学体验结束，389.1元学习全部课时</span>*/}
          {/*  <button className={'purchase'}>立即购买</button>*/}
          {/*</div>*/}
        </div>
      </div>
    );
  }
}

export default InteractiveStudy;