import React, { Component } from 'react';
import './index.scss'
import { html } from "@/utils"
import classnames from 'classnames'


class Question extends Component {

  handleSelect = option => {
    const {selectAnswer} = this.props
    if (selectAnswer) {
      selectAnswer(this.props.question, option.id)
      this.setState({
        selectedId: option.id,
      })
    }
  }

  render() {
    const {question, answer, activeIndex, category} = this.props
    return (
      <div className={'question-container'}>
        {
          <div className="question">
            {activeIndex !== undefined && `${activeIndex + 1}.`}
            {category && <span className={'category'}>{category}</span>}&nbsp;
            <span dangerouslySetInnerHTML={{__html: question.ques}}></span>
          </div>
        }
        <ul className={'options'}>
          {
            !!question.options.length && question.options.map((item, index) => {
              return <li key={item.id}
                         className={classnames({
                           active: answer && answer[question.id] === item.id,
                           error: item.user_select && !item.is_ans,
                           correct: item.is_ans,
                         })}
                         onClick={this.handleSelect.bind(this, item)}>
                <div className={'letter'}>{String.fromCharCode(65 + index)}</div>
                <div>{item.des}</div>
              </li>
            })
          }
        </ul>
      </div>
    );
  }
}

export default Question;