import React, { Component } from 'react'
import './index.scss'

export default class Study extends Component {

  Change = (data) => {
    let cn = ["一", "二", "三", "四", "五", "六", "七", "八", "九", '十'];
    let newStr = ''
    let str = data.toString()
    let ci = Number(str) % 10
    let cs = Math.floor(Number(str) / 10)
    let cv = ''
    if (str.length > 1) {
        if(cs==1){
            cv = ci >= 1 ? cn[9] + cn[ci - 1] : cn[9]
        } else {
            cv = ci > 1 ? cn[cs - 1] + cn[9] + cn[ci - 1] : cn[cs - 1] + cn[9]
        }
    } else {
        cv = cn[ci - 1]
    }
    newStr = str.replace(str, cv)
    return newStr;
  }

  render() {
    return (
      <div className={'study__container'}>
        <img className={'learn_left'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/learn_left.png" alt=""/>
        <img className={'learn_bottom'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/learn_bottom.png" alt=""/>
        <p className={'title'}>阶 / 梯 / 学 / 习</p>
        <p className={'sub__title'}>17节课堂教学，带你掌握Python技术入门知识</p>
        <div className={'step__container'}>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/wanzheng.png" alt=""/>
            <p>完整的Python基础知识体系</p>
            <div className={'item__line'}></div>
          </div>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/siwei.png" alt=""/>
            <p>灵活的编程思维和实操技巧</p>
            <div className={'item__line'}></div>
          </div>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/shicao.png" alt=""/>
            <p>丰富有趣的实操训练</p>
          </div>
        </div>

        <div className={'table__container'}>
          <div className={'table__head'}>
            <div className={'head_title order_number'}>序号</div>
            <div className={'head_title chapter'}>章节</div>
            <div className={'head_title points'}>知识点</div>
          </div>
          <div className={'table__body'}>
            {
              this.props.syllabus.map((item, index)=>{
                return (
                  <div className={'item__container'} key={index}>
                    <div className={'item__title'}>{ 
                    '第' + this.Change(index + 1) + '阶段 ' +item.name}</div>
                    {
                      item.lessons.map((item, index)=>{
                        return (
                          <div className={'item__content'} key={index}>
                            <div className={'content order_number number_center'}>{item.number}</div>
                            <div className={'content chapter'}>{item.name}</div>
                            <div className={'content points'}>{item.info.name}</div>
                          </div>
                        )
                      })
                    }
                  </div>
                )
              })
            }
          </div>
          <div className={'table__bottom'}>
            {
              this.props.allSyllabusShow ? (
                <div onClick={() => this.props.hide(1)}>
                  <p>收起</p>
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/shouqi.png" alt=""/>
                </div>
              ) : (
                <div onClick={() => this.props.show(1)}>
                  <p>展开更多</p>
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/zhankai.png" alt=""/>
                </div>
              )
            }
          </div>
        </div>
      </div>
    )
  }
}
