import React, {Component} from 'react'
import {SendMessageToApp,wxShare} from '@/utils'
import {setCurrentUser, startFetchUser} from "@/store/userAction"
import {Button, Toast, WhiteSpace} from 'antd-mobile'
import cookie from 'js-cookie'
import {addDays} from "date-fns"
import {compose} from "redux";
import {connect} from "react-redux";


class ToAppDemo extends Component {

    state = {
        userInfoList: [],
    }

    componentDidMount() {
        this.getData()
        // 获取App登录信息
        window['loginInfo'] = result => {
            this.loginInfo(result)
        }
    }

    getData = () => {
        Toast.info('获取福气值', 2)
    }

    // 获取app登录数据
    loginInfo = (result) => {
        this.setState({
            userInfoList: result
        })
        if (this.state.userInfoList.length !== 0) {
            this.props.startFetchUser()
            this.appLogin()
        }
    }
    // 保存cookie
    appLogin = () => {
        let expires = addDays(new Date(), 90)
        this.state.userInfoList.map((item, index) => {
            Toast.info(item.version, 3)
            cookie.set("token", item.token, {expires, path: '/', domain: 'julyedu.com'});
            cookie.set("plat", item.plat, {expires, path: '/', domain: 'julyedu.com'});
            cookie.set("uid", item.uid, {expires, path: '/', domain: 'julyedu.com'});
            cookie.set("uname", item.uname, {expires, path: '/', domain: 'julyedu.com'});
            cookie.set("avatar_file", item.avatar_file, {expires, path: '/', domain: 'julyedu.com'});
        });
        this.props.setCurrentUser(this.transformUser(this.state.userInfoList))
    }

    transformUser = res => {
        let payload

        res.map((item, index) => {
            payload = {
                hasError: false,
                data: {
                    username: item.uname,
                    avatar: item.avatar_file,
                    token: item.token,
                    uid: item.uid
                },
                isFetching: false
            }
        })

        return payload
    }
    testShare = () => {
        wxShare({
            title: 'AI充电节，积福气享1折秒课，超10万元奖品来就送！！',
            desc: '把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线',
            link: encodeURI(location.href),
            imgUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/index-share-img.png',
        })
    }


    // 跳转App登录
    toLogin = () => {
        SendMessageToApp("toLogin");
    }

    // 立即付定金
    earnestMoney = (courseId) => {
        SendMessageToApp("earnestMoney", courseId);
    }

    // 去课程详情页
    toCourse = (courseId, type) => {
        let data = {
            courseId: courseId,
            type: type // 正常跳课程详情页type:0,积福气浏览课程详情页-没有浏览过type:1 已浏览过type:2
        }
        SendMessageToApp("toCourse", data);
    }
    // 人工咨询
    toQQ = () => {
        SendMessageToApp("toQQ", 'https://q.url.cn/AB8aue?_type=wpa&qidian=true')
    }
    // 直播间
    toLiveRoom = (toLiveRoom) => {
        SendMessageToApp("toLiveRoom", toLiveRoom)
    }
    // QQ分享
    QQshare = () => {
        // 内容需要和产品确认
        let data = {
            title: 'AI充电节，积福气享1折秒课，超10万元奖品来就送！！',
            desc: '把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线',
            link: 'https://m.julyedu.com/blessingPreheat',
            imgUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/index-share-img.png',
        }
        SendMessageToApp("QQshare", data)
    }
    // 微信分享
    WXshare = () => {
        // 内容需要和产品确认
        let data = {
            title: 'AI充电节，积福气享1折秒课，超10万元奖品来就送！！',
            desc: '把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线',
            link: 'https://m.julyedu.com/blessingPreheat',
            imgUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/index-share-img.png',
        }
        SendMessageToApp("WXshare", data)
    }

    // 邀请好友注册
    toShare = () => {
        let data = {
            title: 'AI充电节，积福气享1折秒课，超10万元奖品来就送！！',
            desc: '把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线',
            link: 'https://m.julyedu.com/blessingPreheat',
            imgUrl: 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/index-share-img.png',
        }
        SendMessageToApp("toShare", data)
    }

    render() {
        return (
            <div>
                <Button type={'primary'} onClick={() => this.testShare()}>测试分享</Button><WhiteSpace/>
                <p>登录</p>
                <Button type={'primary'} onClick={() => this.toLogin()}>跳App登录</Button><WhiteSpace/>
                <p>去课程详情页</p>
                <Button type={'primary'} onClick={() => this.toCourse(165, 0)}>课程详情页</Button><WhiteSpace/>
                <p>积福气</p>
                <Button type={'primary'} onClick={() => this.toCourse(165, 1)}>浏览课程详情页</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.QQshare()}>分享（QQ）</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.WXshare()}>分享（微信）</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.toShare()}>邀请好友注册</Button><WhiteSpace/>
                <p>定金相关</p>
                <Button type={'primary'} onClick={() => this.earnestMoney(165)}>立即付定金</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.toCourse(165, 0)}>去学习（跳课程详情页）</Button><WhiteSpace/>
                <p>精品特惠</p>
                <Button type={'primary'} onClick={() => this.toQQ()}>立抢超低团购价(跳人工咨询)</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.toCourse(165, 0)}>开始使用（跳课程详情页）</Button><WhiteSpace/>
                <Button type={'primary'} onClick={() => this.toCourse(165, 0)}>一分钱开团（跳课程详情页）</Button><WhiteSpace/>
                <p>大咖直播</p>
                <Button type={'primary'} onClick={() => this.toLiveRoom(100)}>正在直播</Button><WhiteSpace/>
            </div>
        )
    }
}


export default compose(
    connect(
        state => ({user: state.user}),
        {setCurrentUser, startFetchUser}
    )
)(ToAppDemo)