import React, { Component } from 'react'
import './index.scss'

export default class CommonContainer extends Component {
  constructor(props) {
    super(props)
  }
  render() {
    const { id } = this.props;
    return (
      <div className='common_container' id={id}>
        <div className='container_top'></div>
        <div className='container_content'>
            {
                this.props.title &&
                <div className='title_container'>
                    <i></i>
                    <p>{this.props.title}</p>
                    <i></i>
                </div>
            }
          {
            React.Children.map(this.props.children, function (child) {
              return <>{child}</>;
            })
          }
        </div>
        <div className='container_bottom'></div>
      </div>
    )
  }
}
