import React, { Component } from 'react'
import './index.scss'
import { http, SendMessageToApp, getParam, browser } from '@/utils'
import CommonContainer from './../../common/commonContainer/index'
import CourseItem from '../../../../blessingPreheat/courseItem/index'
import { withRouter } from "react-router-dom"
import CommonPopup from './../../common/commonPopup/index'
import { Toast } from 'antd-mobile'
import QRCode from 'qrcode'
import { connect } from "react-redux"
import dateFns from 'date-fns';

@connect(state => ({
    user: state.user
}))

class YearCourse extends Component {
    constructor(props) {
        super(props)
        this.state = {
            tofreeStudy: false,
            basic: {
                course: [],
                courseList: [],
                isMore: false,
                addshowMore: false,
            },
            advanced: {
                course: [],
                courseList: [],
                isMore: false,
                addshowMore: false,
            },
            higher: {
                course: [],
                courseList: [],
                isMore: false,
                addshowMore: false,
            },
            expand: {
                course: [],
                courseList: [],
                isMore: false,
                addshowMore: false,
            },
            bigcourse: {
                course: [],
                courseList: [],
                isMore: false,
            },
            freecourse: {
                course: [],
                courseList: [],
                isMore: false,
            },
            groupcourse: {
                course: [],
                courseList: [],
                isMore: false,
            },
            isshowFollow: false, // 是否提示关注公众号
            wish: {
                id: '',
                key: ""
            },
            followBarcode: '',
            qrUrl: '',
            sum: '',
            removable: '',
            currentId: '',
        }
    }

    componentDidMount() {
        this.getTeamInfo()
        this.getLength()
        this.fetchBigCourse()
        this.fetchFreeCourse()
        this.fetchGroupCourse()
        // AI之路-基础
        this.fetchAICourse('one', false)
        // AI之路-进阶
        this.fetchAICourse('two', false)
        // AI之路-高阶
        this.fetchAICourse('three', false)
        // AI之路-拓展
        this.fetchAICourse('four', false)
    }

    shouldComponentUpdate(nextProps, nextState, nextContext) {
        if (this.props.isAppUpdate !== nextProps.isAppUpdate) {
            this.getTeamInfo()
            this.getLength()
            this.fetchBigCourse()
            this.fetchFreeCourse()
            this.fetchGroupCourse()
            // AI之路-基础
            this.fetchAICourse('one')
            // AI之路-进阶
            this.fetchAICourse('two')
            // AI之路-高阶
            this.fetchAICourse('three')
            // AI之路-拓展
            this.fetchAICourse('four')
            return false
        }
        return true
    }

    getLength = () => {
        let _this = this
        http.get(`${API.home}/activity/wish_sum`).then(res => {
            const { code, data } = res.data
            if (code == 200) {
                _this.setState({
                    sum: data.sum
                })
            }
        })
    }

    fetchBigCourse = () => {
        const { bigcourse } = this.state
        http.get(`${API.home}/activity/preheat_data`).then(res => {
            const { code, data } = res.data
            if (code === 200) {
                this.setState({
                    bigcourse: Object.assign({}, bigcourse, {
                        isMore: false,
                        course: data,
                        courseList: data,
                    })
                })
            }
        })
    }
    fetchFreeCourse = () => {
        const { freecourse } = this.state
        http.get(`${API['base-api']}/assistance/detail`).then(res => {
            const { errno, data } = res.data
            if (errno === 200) {
                this.setState({
                    freecourse: Object.assign({}, freecourse, {
                        isMore: data.course_info.length > 4 ? true : false,
                        course: data.course_info.length > 4 ? data.course_info.filter((item, index) => index < 4) : data.course_info,
                        courseList: data.course_info,
                    })
                })
            }
        })
    }

    fetchGroupCourse = () => {
        const { groupcourse } = this.state
        http.get(`${API.home}/activity/excellent_course`).then(res => {
            const { code, data } = res.data
            if (code === 200) {
                this.setState({
                    groupcourse: Object.assign({}, groupcourse, {
                        isMore: data.length > 4 ? true : false,
                        course: data.length > 4 ? data.filter((item, index) => index < 4) : data,
                        courseList: data,
                    })
                })
            }
        })
    }

    fetchAICourse = (key, addshowMore) => {
        http.get(`${API.home}/activity/four_stage/${key}`).then(res => {
            const { code, data } = res.data
            if (code === 200) {
                this.getList(key, data, addshowMore)
            }
        })
    }

    getList = (key, data, addshowMore) => {
        const { basic, advanced, higher, expand } = this.state
        if (key === 'one') {
            this.setState({
                basic: Object.assign({}, basic, {
                    isMore: data.length > 4 && !addshowMore ? true : false,
                    course: data.length > 4 && !addshowMore ? data.filter((item, index) => index < 4) : data,
                    courseList: data,
                    addshowMore: addshowMore,
                })
            })
        }
        if (key === 'two') {
            this.setState({
                advanced: Object.assign({}, advanced, {
                    isMore: data.length > 4 && !addshowMore ? true : false,
                    course: data.length > 4 && !addshowMore ? data.filter((item, index) => index < 4) : data,
                    courseList: data,
                    addshowMore: addshowMore,
                })
            })
        }
        if (key === 'three') {
            this.setState({
                higher: Object.assign({}, higher, {
                    isMore: data.length > 4 && !addshowMore ? true : false,
                    course: data.length > 4 && !addshowMore ? data.filter((item, index) => index < 4) : data,
                    courseList: data,
                    addshowMore: addshowMore,
                })
            })
        }
        if (key === 'four') {
            this.setState({
                expand: Object.assign({}, expand, {
                    isMore: data.length > 4 && !addshowMore ? true : false,
                    course: data.length > 4 && !addshowMore ? data.filter((item, index) => index < 4) : data,
                    courseList: data,
                    addshowMore: addshowMore,
                })
            })
        }
    }

    toQQque = () => {
        if (!getParam('version')) {
            location.href = 'https://q.url.cn/AB8aue?_type=wpa&qidian=true'
        } else {
            SendMessageToApp("toQQ", 'https://q.url.cn/AB8aue?_type=wpa&qidian=true')
        }
    }

    // 去课程详情页
    toCourse = (courseId) => {
        const { history } = this.props
        if (!getParam('version')) {
            history.push(`/detail?id=${courseId}`)
        } else {
            SendMessageToApp("toCourse", courseId)
        }
    }

    handleToMore = (key) => {
        let data = {}
        if (this.state[key]['isMore']) {
            data[key] = {
                isMore: !this.state[key]['isMore'],
                course: this.state[key]['courseList'],
                courseList: this.state[key]['courseList'],
                addshowMore: !this.state[key]['addshowMore']
            }
            this.setState({
                ...data
            })
        } else {
            data[key] = {
                isMore: !this.state[key]['isMore'],
                course: this.state[key]['courseList'].filter((item, index) => index < 4),
                courseList: this.state[key]['courseList'],
                addshowMore: !this.state[key]['addshowMore']
            }

            this.setState({
                ...data
            })
        }
    }

    // 去登录
    toLogin = () => {
        if (!getParam('version')) {
            this.props.history.push('/passport/login')
        } else {
            SendMessageToApp("toLogin")
        }
    }

    // 免费学习
    freeStudy = () => {
        this.setState({
            tofreeStudy: true,
        })
    }

    // 关闭弹框
    closePopup = () => {
        this.setState({
            tofreeStudy: false,
        })
    }

    closePopupWish = () => {
        const _this = this
        _this.setState({
            isshowFollow: false
        })

        setTimeout(function () {
            _this.toJoinList(_this.state.wish.id, _this.state.wish.key)
        }, 200)
    }

    getQRcodeUrl = () => {
        let _this = this
        http.get(`${API['base-api']}/wx/user_temporary_qrcode/${_this.props.user.data.uid}`)
            .then(res => {
                const { errno, data, msg } = res.data
                if (errno == 0) {
                    this.setState({
                        qrUrl: data.url
                    })
                    QRCode.toDataURL(data.url, (err, url) => {
                        this.setState({
                            followBarcode: url,
                        })
                    })
                } else {
                    Toast.info(msg, 2)
                }
            })
    }

    // 点击加入心愿单登录验证，在判断是否关注公众号，已关注的话直接加入，未关注弹出二维码弹窗，点击关闭按钮加入心愿单
    addWishList = (id, key) => {
        const _this = this
        const isLogin = !this.props.user.hasError
        _this.setState({
            wish: {
                id: id,
                key: key
            }
        })

        if (isLogin) {
            _this.isFollow(id, key)
        } else {
            _this.toLogin()
        }
    }

    isFollow = (id, key) => {
        const _this = this
        http.get(`${API.home}/sys/user/isFollowWeChat`).then(res => {
            const { code, data, msg } = res.data
            if (code === 200) {
                _this.setState({
                    isshowFollow: !data.is_follow
                })

                if (!_this.state.isshowFollow) {
                    _this.toJoinList(id, key)
                } else {
                    _this.getQRcodeUrl()
                }
            } else {
                Toast.info(msg, 2)
            }
        })
    }

    toJoinList = (id, key) => {
        const _this = this
        http.post(`${API.home}/activity/join_list`, { course_id: id })
            .then(res => {
                const { code, msg } = res.data
                if (code == 200) {
                    Toast.success('已成功加入心愿单', 3)
                    _this.getLength()
                    if (key === '1') {
                        _this.fetchAICourse('one', _this.state.basic.addshowMore)
                    }
                    if (key === '2') {
                        _this.fetchAICourse('two', _this.state.advanced.addshowMore)
                    }
                    if (key === '3') {
                        _this.fetchAICourse('three', _this.state.higher.addshowMore)
                    }
                    if (key === '4') {
                        _this.fetchAICourse('four', _this.state.expand.addshowMore)
                    }
                    if (key === 'group') {
                        _this.fetchGroupCourse()
                    }
                } else {
                    Toast.info(msg, 2)
                }
            })
    }

    // 安卓手机保存二维码
    saveImage = () => {
        let version = getParam('version')
        version = typeof version === 'string' ? version.replace('.', '').replace('.', '').slice(0, 3) : ''
        const QRCodeUrl = this.state.qrUrl
        if (version && parseInt(version) < 451) {
            Toast.info('当前不支持此功能，升级到最新版本app可以点击保存二维码！', 3, null, false)
        } else {
            SendMessageToApp('generateQRCode', QRCodeUrl)
        }
    }

    saveImage2 = () => {
        let version = getParam('version')
        version = typeof version === 'string' ? version.replace('.', '').replace('.', '').slice(0, 3) : ''
        const QRCodeUrl = 'https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/2018christyear/h5/qrcode.jpg'
        if (version && parseInt(version) < 451) {
            Toast.info('当前不支持此功能，升级到最新版本app可以点击保存二维码！', 3, null, false)
        } else {
            SendMessageToApp('saveImage', QRCodeUrl)
        }
    }

    // 获取队伍信息
    getTeamInfo = () => {
        http.get(`${API.home}/sys/treasure/teamInfo`).then(res => {
            const { code, data, msg } = res.data
            if (code === 200) {
                const { info, removable_data } = data
                this.setState({
                    removable: info.removable,
                    currentId: info.removable > 0 ? removable_data[0].id : null
                })
            } else {
                Toast.info(msg)
            }
        })
    }

    // 跳转到我的宝箱列表页
    toBoxList = () => {
        const isLogin = !this.props.user.hasError
        const { currentId } = this.state
        let search = ''
        if (currentId) {
            search = `?id=${currentId}`
        }
        if (isLogin) {
            if (!getParam('version')) {
                this.props.history.push(`/year/yearTreasure${search}`)
            } else {
                this.props.history.push(`/year/yearTreasure${search}?version=${getParam('version')}`)
            }
        } else {
            this.toLogin()
        }
    }

    toYearWish = () => {
        const isLogin = !this.props.user.hasError
        if (isLogin) {
            if (!getParam('version')) {
                this.props.history.push('/year/yearWish')
            } else {
                this.props.history.push(`/year/yearWish?version=${getParam('version')}`)
            }

        } else {
            this.toLogin()
        }

    }

    toInviteFriends = (oid, params = {}) => {
        const { history } = this.props
        if (getParam('version')) {
            let data = {
                title: `【仅剩${params.number}个名额】我${params.price}元拼了《${params.course_title}》`,
                desc: params.course_title,
                link: `${API.m}/togroup?id=${oid}`,
                imgUrl: params.image_name,
            }
            SendMessageToApp("toShare", data)
        } else {
            history.push(`/togroup?id=${oid}`);
        }
    }

    isCountDown = (condition, val) => {
        if (condition) {
            return val;
        }
        return '';
    }

    formatTitleAndKey = (key) => {
        let data = null;
        switch (key) {
            case 1:
                data = {
                    title: '基础',
                    key: 'basic'
                };
                break;
            case 2:
                data = {
                    title: '进阶',
                    key: 'advanced'
                };
                break;
            case 3:
                data = {
                    title: '高阶',
                    key: 'higher'
                };
                break;
            case 4:
                data = {
                    title: '扩展',
                    key: 'expand'
                };
                break;
            default:
                data = null;
                break;
        }
        return data;
    }

    formatCourseData = (key) => {
        const { basic, advanced, higher, expand } = this.state;
        let data = null;
        switch (key) {
            case 1:
                data = basic;
                break;
            case 2:
                data = advanced;
                break;
            case 3:
                data = higher;
                break;
            case 4:
                data = expand;
                break;
            default:
                data = null;
                break;
        }
        return data;
    }

    toCart = (id) => {
        const { history } = this.props;
        http.post(`${API.home}/m/cart/add`, {
            course_id: id
        }).then((res) => {
            const { code, msg } = res.data;
            // code 15001 已加入购物车
            if (code === 200 || code === 15001) {
                if(getParam('version')) {
                    SendMessageToApp('toShoppingCart')
                }else {
                    history.push('/shopcart');
                }
            } else if (code === 4030 || code === 4040) {
                this.toLogin();
            } else {
                Toast.info(msg, 2);
            }
        })
    };

    toContinueBargain = (id, price, code, image) => {
        const { history } = this.props;
        if(getParam('version')) {
            let data = {
                title: '我发现一门好课，快来帮我砍价吧！',
                desc: `我已经砍了${price}元，看看你能砍多少`,
                link: `${API.m}/bargain-middle-page?id=${id}&bargaincode=${code}&is_originator=1`,
                imgUrl: image,
            }
            SendMessageToApp("toShare", data)
        }else {
            history.push(`/bargain-middle-page?id=${id}&bargaincode=${code}&is_originator=1`);
        }
    }

    // 砍完价去支付
    bargainToOrder = (id) => {
        const { history, user } = this.props;
        if(user.hasError) {
            this.toLogin();
        }else{
            if(getParam('version')) {
                SendMessageToApp('toPay', id)
            }else {
                http.get(`${API['base-api']}/m/cart/addtopreorder/[${id}]`).then((res) => {
                    const { errno, msg } = res.data;
                    if (errno === 0) {
                        history.push(`/order?id=[${id}]`, {bargain: 1});
                    } else {
                        Toast.info(msg, 2);
                    }
                })
            }
        }
    }

    render() {
        const {
            bigcourse,
            freecourse,
            groupcourse,
            basic,
            advanced,
            higher,
            expand,
            removable,
            sum,
        } = this.state
        const { stage } = this.props
        return (
            <div className={'year-index-course'}>

                {/*浮框*/}
                <div className='nav-right'>
                    <span onClick={this.toBoxList} className='nav-right__link'>
                        未开宝箱
                        {
                            removable > 0 &&
                            <i className="nav-right__number">{removable}</i>
                        }
                    </span>
                    <a onClick={() => this.toYearWish()} className='nav-right__link'>
                        心愿单
                        {
                            sum > 0 &&
                            <i className="nav-right__number">{sum}</i>
                        }
                    </a>
                </div>

                {/* 重磅好课 */}
                <CommonContainer title='重磅好课' id='year-course'>
                    {
                        (bigcourse.course && bigcourse.course.length > 0) &&
                        <>
                            <div className='bigcourse course-box'>
                                {
                                    bigcourse.course.map(item => (
                                        <CourseItem
                                            image={item.image_name}
                                            key={item.course_id}
                                            id={item.course_id}
                                            toCourse={this.toCourse}
                                        >
                                            <div className="coupon-course__footer">
                                                {
                                                    item.is_buy == 1 &&
                                                    <a
                                                        onClick={() => this.toCourse(item.course_id)}
                                                        className="btn to-study"
                                                    >开始学习</a>
                                                }
                                                {
                                                    item.is_buy == 0 &&
                                                    <a
                                                        onClick={() => this.toQQque()}
                                                        className="btn big-course"
                                                    >免费试听</a>
                                                }
                                            </div>
                                        </CourseItem>
                                    ))
                                }
                            </div>
                            {/* {
                                (bigcourse.courseList && bigcourse.courseList.length > 4) &&
                                <button
                                    className="more-button"
                                    onClick={() => this.handleToMore('bigcourse')}
                                >{bigcourse.isMore ? '查看更多' : '收起'}</button>
                            } */}
                        </>
                    }
                </CommonContainer>

                {/* 人气好课免费学 */}
                <CommonContainer title='人气好课免费学' id='year-free'>
                    {
                        (freecourse.course && freecourse.course.length > 0) &&
                        <>
                            <div className='freecourse course-box'>
                                {
                                    freecourse.course.map(item => (
                                        <CourseItem
                                            image={item.image_name}
                                            key={item.course_id}
                                            id={item.course_id}
                                            toCourse={this.toCourse}
                                        >
                                            <div className="coupon-course__footer">
                                                {
                                                    item.is_buy == 1 &&
                                                    <a
                                                        onClick={() => this.toCourse(item.course_id)}
                                                        className="btn to-study"
                                                    >开始学习</a>
                                                }
                                                {
                                                    item.is_buy == 0 &&
                                                    <a
                                                        onClick={() => this.freeStudy()}
                                                        className="btn free-study"
                                                    >点击免费学</a>
                                                }
                                                <p className="free-course-num">
                                                    已送出<span>{item.act_num}</span>个课程
                                                </p>
                                            </div>
                                        </CourseItem>
                                    ))
                                }
                            </div>
                            {
                                (freecourse.courseList && freecourse.courseList.length > 4) &&
                                <button
                                    className="more-button"
                                    onClick={() => this.handleToMore('freecourse')}
                                >{freecourse.isMore ? '查看更多' : '收起'}</button>
                            }
                        </>
                    }
                </CommonContainer>

                {/* stage，活动阶段 0-不在活动时间 1-预热 2-正式 3-返场 */}
                {
                    Number(stage) === 2 &&
                    <>
                        {/* 精品好课1分开抢 */}
                        <CommonContainer title='精品好课1分开抢' id='year-group'>
                            {
                                (groupcourse.course && groupcourse.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box' data-stage="2">
                                        {
                                            groupcourse.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    time={this.isCountDown(item.is_assemble === 1, item.add_time)}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="coupon-course__footer">

                                                        {/* is_assemble 0 未拼团 1 正在拼团 2 已购买 */}
                                                        {
                                                            item.is_assemble == 2 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="btn to-group"
                                                                        data-status="study"
                                                                    >开始学习</a>
                                                                </div>
                                                            </>
                                                        }
                                                        {
                                                            item.is_assemble != 2 &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag" data-color="green">拼团价</span>
                                                                </div>
                                                                <div className="price price-group">
                                                                    <span className="price-label">¥</span>
                                                                    <span className="new-price">0.01</span>
                                                                    <span className="old-price">
                                                                        <s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                {
                                                                    item.is_assemble == 0 &&
                                                                    <div className="progree-and-sale">
                                                                        <div className="progress">
                                                                            <i
                                                                                className="progress_bar"
                                                                                style={{
                                                                                    width: `${item.progress}%`
                                                                                }}
                                                                            ></i>
                                                                        </div>
                                                                        <p className="sale-sum">
                                                                            {Number(item.sum <= 285) ? `已抢${item.sum}个` : '即将售罄'}
                                                                        </p>
                                                                    </div>
                                                                }
                                                                <div className="status">
                                                                    {
                                                                        item.is_assemble == 0 &&
                                                                        <a
                                                                            onClick={() => this.toCourse(item.course_id)}
                                                                            className="status-btn to-group"
                                                                        >马上抢>></a>
                                                                    }
                                                                    {
                                                                        item.is_assemble == 1 &&
                                                                        <a
                                                                            onClick={() => this.toInviteFriends(item.order_id, {
                                                                                number: item.number,
                                                                                course_title: item.course_title,
                                                                                image_name: item.image_name,
                                                                                price: 0.01
                                                                            })}
                                                                            className="status-btn to-group"
                                                                            data-status="done"
                                                                        >已参团，邀请好友参团</a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (groupcourse.courseList && groupcourse.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('groupcourse')}
                                        >{groupcourse.isMore ? '查看更多' : '收起'}</button>
                                    }
                                </>
                            }
                        </CommonContainer>

                        {/* 好课价到，等你抄底 */}
                        <CommonContainer title='好课价到，等你抄底' id='year-discount'>
                            {
                                [1, 2, 3, 4].map(item => {
                                    const keys = this.formatTitleAndKey(item);
                                    const data = this.formatCourseData(item);
                                    return (
                                        <React.Fragment key={item}>
                                            <h4 className="ai-course__subtitle">{keys.title}</h4>
                                            {
                                                (data.course && data.course.length > 0) &&
                                                <>
                                                    <div className='groupcourse course-box'>
                                                        {
                                                            data.course.map(val => {
                                                                return (
                                                                    <CourseItem
                                                                        image={val.image_name}
                                                                        key={val.course_id}
                                                                        id={val.course_id}
                                                                        time={this.isCountDown(val.type === 2, val.end_time)}
                                                                        toCourse={this.toCourse}
                                                                    >
                                                                        <div className="coupon-course__footer">

                                                                            {/* type 1 立即参团 2 已参团 3 我要砍价 4 已参加砍价 可以继续砍价 5 马上抢 6 开始学习 7 已参加一分钱拼团 8 砍价待支付 */}

                                                                            {
                                                                                (val.type === 4 || val.type === 8) &&
                                                                                <div className="bargain-price">已砍{val.already_bargain}元</div>
                                                                            }

                                                                            {
                                                                                val.type === 0 &&
                                                                                <>
                                                                                    <div className="type">
                                                                                        <span className="tag" data-color="green">活动价</span>
                                                                                    </div>
                                                                                    <div className="price price-group">
                                                                                        <span className="price-label">¥</span>
                                                                                        <span className="new-price">{val.original_price}</span>
                                                                                        <span className="old-price">
                                                                                            <s>¥{val.original_price}</s>
                                                                                        </span>
                                                                                    </div>
                                                                                </>
                                                                            }
                                                                            {
                                                                                (val.type === 1 || val.type === 2) &&
                                                                                <>
                                                                                    <div className="type">
                                                                                        <span className="tag" data-color="green">拼团价</span>
                                                                                    </div>
                                                                                    <div className="price price-group">
                                                                                        <span className="price-label">¥</span>
                                                                                        <span className="new-price">{val.pdd_price}</span>
                                                                                        <span className="old-price">
                                                                                            <s>¥{val.original_price}</s>
                                                                                        </span>
                                                                                    </div>
                                                                                </>
                                                                            }
                                                                            {
                                                                                (val.type === 3 || val.type === 4 || val.type === 8) &&
                                                                                <>
                                                                                    <div className="type">
                                                                                        <span className="tag" data-color="green">好友帮帮砍</span>
                                                                                    </div>
                                                                                    <div className="price price-group">
                                                                                        <span className="price-label">到手最低：¥</span>
                                                                                        <span className="new-price">{val.low_prize}</span>
                                                                                        <span className="old-price">
                                                                                            <s>¥{val.original_price}</s>
                                                                                        </span>
                                                                                    </div>
                                                                                </>
                                                                            }
                                                                            {
                                                                                val.type === 6 &&
                                                                                <p className={'course-title text-overflow-1'}>
                                                                                    {val.course_title}
                                                                                </p>
                                                                            }

                                                                            <div className="status" data-layout={val.type ===4? 'row': '' }>
                                                                                {
                                                                                    val.type === 0 &&
                                                                                    <a
                                                                                        onClick={() => this.toCart(val.course_id)}
                                                                                        className="status-btn to-group"
                                                                                    >立即购买</a>
                                                                                }
                                                                                {
                                                                                    val.type === 1 &&
                                                                                    <a
                                                                                        onClick={() => this.toCourse(val.course_id)}
                                                                                        className="status-btn to-group"
                                                                                    >立即参与拼团</a>
                                                                                }
                                                                                {
                                                                                    val.type === 2 &&
                                                                                    <a
                                                                                        onClick={() => this.toInviteFriends(val.order_id, {
                                                                                            number: val.number,
                                                                                            course_title: val.course_title,
                                                                                            image_name: val.image_name,
                                                                                            price: val.pdd_price
                                                                                        })}
                                                                                        className="status-btn to-group"
                                                                                        data-status="done"
                                                                                    >已参团，邀请好友参团</a>
                                                                                }
                                                                                {
                                                                                    val.type === 3 &&
                                                                                    <a
                                                                                        onClick={() => this.toCourse(val.course_id)}
                                                                                        className="status-btn to-group"
                                                                                    >我要砍价</a>
                                                                                }
                                                                                {
                                                                                    val.type === 4 &&
                                                                                    <>
                                                                                        <a
                                                                                            onClick={() => this.toContinueBargain(val.course_id, val.already_bargain, val.bargain_code, val.image_name)}
                                                                                            className="status-btn to-group"
                                                                                        >继续砍价</a>
                                                                                        <a
                                                                                            onClick={() => this.bargainToOrder(val.course_id)}
                                                                                            className="status-btn to-group"
                                                                                        >支付{val.actual_payment}元</a>
                                                                                    </>
                                                                                }
                                                                                {
                                                                                    val.type === 8 &&
                                                                                    <a
                                                                                        onClick={() => this.bargainToOrder(val.course_id)}
                                                                                        className="status-btn to-group"
                                                                                    >支付{val.actual_payment}元</a>
                                                                                }
                                                                                {
                                                                                    val.type === 6 &&
                                                                                    <a
                                                                                        onClick={() => this.toCourse(val.course_id)}
                                                                                        className="btn to-group"
                                                                                        data-status="study"
                                                                                    >开始学习</a>
                                                                                }
                                                                            </div>
                                                                        </div>
                                                                    </CourseItem>
                                                                )
                                                            })
                                                        }
                                                    </div>
                                                    {
                                                        (data.courseList && data.courseList.length > 4) &&
                                                        <button
                                                            className="more-button"
                                                            onClick={() => this.handleToMore(keys.key)}
                                                        >{data.isMore ? '查看更多' : '收起'}</button>
                                                    }
                                                </>
                                            }
                                        </React.Fragment>
                                    )
                                })
                            }
                        </CommonContainer>
                    </>
                }
                {
                    Number(stage) !== 2 &&
                    <>
                        {/* 精品好课1分开抢 */}
                        <CommonContainer title='精品好课1分开抢' id='year-group'>
                            {
                                (groupcourse.course && groupcourse.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box'>
                                        {
                                            groupcourse.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="group-num">限量300个</div>
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag">拼团价</span>
                                                                    <span className="time">12月23日开团</span>
                                                                </div>
                                                                <div className="price">
                                                                    ¥
                                                                    <span className="new-price">0.01</span>
                                                                    <span className="old-price">
                                                                        现价：<s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id, 'group')}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (groupcourse.courseList && groupcourse.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('groupcourse')}
                                        >{groupcourse.isMore ? '查看更多' : '收起'}</button>
                                    }
                                </>
                            }
                        </CommonContainer>

                        {/* 好课价到，等你抄底 */}
                        <CommonContainer title='好课价到，等你抄底' id='year-discount'>
                            <h4 className="ai-course__subtitle">基础</h4>
                            {
                                (basic.course && basic.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box'>
                                        {
                                            basic.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    {
                                                                        item.type == 0 &&
                                                                        <>
                                                                            <span className="tag">活动价</span>
                                                                            <span className="time">12.23开始</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 1 &&
                                                                        <>
                                                                            <span className="tag">拼团价</span>
                                                                            <span className="time">12.23开团</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 2 &&
                                                                        <>
                                                                            <span className="tag">好友帮帮砍</span>
                                                                            <span className="time">12.23开砍</span>
                                                                        </>
                                                                    }
                                                                </div>
                                                                <div className="price">
                                                                    {item.type == 2 ? '到手最低:¥' : '¥'}
                                                                    <span className="new-price">{item.price2}</span>
                                                                    <span className="old-price">
                                                                        {item.type == 2 ? '' : '现价：'}
                                                                        <s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id, '1')}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (basic.courseList && basic.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('basic')}
                                        >{basic.isMore ? '查看更多' : '收起'}</button>
                                    }
                                </>
                            }
                            <h4 className="ai-course__subtitle">进阶</h4>
                            {
                                (advanced.course && advanced.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box'>
                                        {
                                            advanced.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    {
                                                                        item.type == 0 &&
                                                                        <>
                                                                            <span className="tag">活动价</span>
                                                                            <span className="time">12.23开始</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 1 &&
                                                                        <>
                                                                            <span className="tag">拼团价</span>
                                                                            <span className="time">12.23开团</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 2 &&
                                                                        <>
                                                                            <span className="tag">好友帮帮砍</span>
                                                                            <span className="time">12.23开砍</span>
                                                                        </>
                                                                    }
                                                                </div>
                                                                <div className="price">
                                                                    {item.type == 2 ? '到手最低:¥' : '¥'}
                                                                    <span className="new-price">{item.price2}</span>
                                                                    <span className="old-price">
                                                                        {item.type == 2 ? '' : '现价：'}
                                                                        <s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id, '2')}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (advanced.courseList && advanced.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('advanced')}
                                        >
                                            {advanced.isMore ? '查看更多' : '收起'}
                                        </button>
                                    }
                                </>
                            }
                            <h4 className="ai-course__subtitle">高阶</h4>
                            {
                                (higher.course && higher.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box'>
                                        {
                                            higher.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    {
                                                                        item.type == 0 &&
                                                                        <>
                                                                            <span className="tag">活动价</span>
                                                                            <span className="time">12.23开始</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 1 &&
                                                                        <>
                                                                            <span className="tag">拼团价</span>
                                                                            <span className="time">12.23开团</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 2 &&
                                                                        <>
                                                                            <span className="tag">好友帮帮砍</span>
                                                                            <span className="time">12.23开砍</span>
                                                                        </>
                                                                    }
                                                                </div>
                                                                <div className="price">
                                                                    {item.type == 2 ? '到手最低:¥' : '¥'}
                                                                    <span className="new-price">{item.price2}</span>
                                                                    <span className="old-price">
                                                                        {item.type == 2 ? '' : '现价：'}
                                                                        <s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id, '3')}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (higher.courseList && higher.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('higher')}
                                        >{higher.isMore ? '查看更多' : '收起'}</button>
                                    }
                                </>
                            }
                            <h4 className="ai-course__subtitle">扩展</h4>
                            {
                                (expand.course && expand.course.length > 0) &&
                                <>
                                    <div className='groupcourse course-box'>
                                        {
                                            expand.course.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>
                                                                    {item.course_title}
                                                                </p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    {
                                                                        item.type == 0 &&
                                                                        <>
                                                                            <span className="tag">活动价</span>
                                                                            <span className="time">12.23开始</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 1 &&
                                                                        <>
                                                                            <span className="tag">拼团价</span>
                                                                            <span className="time">12.23开团</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 2 &&
                                                                        <>
                                                                            <span className="tag">好友帮帮砍</span>
                                                                            <span className="time">12.23开砍</span>
                                                                        </>
                                                                    }

                                                                </div>
                                                                <div className="price">
                                                                    {item.type == 2 ? '到手最低:¥' : '¥'}
                                                                    <span className="new-price">{item.price2}</span>
                                                                    <span className="old-price">
                                                                        {item.type == 2 ? '' : '现价：'}
                                                                        <s>¥{item.price1}</s>
                                                                    </span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id, '4')}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                    {
                                        (expand.courseList && expand.courseList.length > 4) &&
                                        <button
                                            className="more-button"
                                            onClick={() => this.handleToMore('expand')}
                                        >{expand.isMore ? '查看更多' : '收起'}</button>
                                    }
                                </>
                            }
                        </CommonContainer>
                    </>
                }

                {
                    this.state.tofreeStudy &&
                    <CommonPopup top={100} closePopup={this.closePopup} mark={false}>
                        <div className='sub__code_container'>
                            <p className='sub__title'>提醒服务</p>
                            <p className='sub__tip'>进入服务号回复<i>77</i>免费领取课程</p>
                            <img className='sub__qr_code' id={'live-qr-code'}
                                src='//julyedu-cdn.oss-cn-beijing.aliyuncs.com/2018christyear/h5/qrcode.jpg' alt="" />
                            {
                                browser.isAndroidApp ? (
                                    <button className={'save-image'} onClick={this.saveImage2}>保存二维码</button>
                                ) : <p className='sub__tip'>长按识别/扫码 关注【七月在线】服务号</p>
                            }
                        </div>
                    </CommonPopup>
                }
                {
                    this.state.isshowFollow &&
                    <CommonPopup top={100} closePopup={this.closePopupWish} mark={false}>
                        <div className='sub__code_container'>
                            <p className='sub__title'>提醒服务</p>
                            <p className='sub__tip'>课程开售立即提醒，不错过任何优惠哦！</p>
                            <img className='sub__qr_code' id={'live-qr-code'}
                                src={this.state.followBarcode} alt="" />
                            {
                                browser.isAndroidApp ? (
                                    <button className={'save-image'} onClick={this.saveImage}>保存二维码</button>
                                ) : <p className='sub__tip'>长按识别/扫码 关注【七月在线】服务号</p>
                            }
                        </div>
                    </CommonPopup>
                }
            </div>
        )
    }
}

export default withRouter(YearCourse)
