import React, { Component } from 'react'
import Swiper from 'swiper'
import 'swiper/dist/css/swiper.min.css'
import './system-bullet-screen.scss'


class SystemBulletScreen extends Component {

  swiper
  count = 0
  sysNotice

  state = {
    showNotices: true
  }

  componentDidMount() {
    this.initializeSwiper()
  }

  componentWillUnmount() {
    this.swiper && this.swiper.destroy()
  }

  initializeSwiper = () => {
    const _this = this
    this.swiper = new Swiper('.sys-bullet-screen-swiper-container', {
      allowTouchMove: false,
      direction: 'vertical',
      loop: true,
      on: {
        init() {
          Array.from(this.slides).forEach(item => {
            item.querySelector('span').addEventListener('transitionend', _this.transitionEnd)
          })
        },
        slideChangeTransitionEnd() {
          _this.slideHorizontal(this)
        },
        transitionEnd() {
          const el = this.slides[this.previousIndex].querySelector('span')
          el.style.transition = 'unset'
          el.style.transform = 'translate3d(0,0,0)'
        }
      }
    })
  }

  slideHorizontal = (swiper) => {
    let el = swiper.slides[swiper.activeIndex],
      content = el.querySelector('span'),
      contentWidth = content.offsetWidth,
      wrapperWidth = el.clientWidth

    const co = 131.25

    if (contentWidth > wrapperWidth) {
      content.style.transition = `transform ${contentWidth / co}s linear`
      setTimeout(() => {
        content.style.transform = `translate3d(${-(contentWidth - wrapperWidth) - 10}px,0,0)`
      }, 1000)
    } else {
      const {bullets} = this.props
      const len = bullets.length * 3
      setTimeout(() => {
        if (++this.count === len) {
          this.sysNotice.style.height = `0px`
        }
        (swiper && !swiper.destroyed) && swiper.slideNext()
      }, 3000)
    }
  }

  transitionEnd = () => {
    const {bullets} = this.props

    const len = bullets.length * 3
    if (++this.count === len) {
      setTimeout(() => {
        this.sysNotice.style.height = `0px`
      }, 2000)
    } else {
      setTimeout(() => {
        this.swiper && this.swiper.slideNext()
      }, 1000)
    }
  }

  removeSystemNotices = e => {
    e.persist()
    if (e.target === this.sysNotice) {
      this.setState({
        showNotices: false
      })
    }
  }

  render() {
    const {
      bullets
    } = this.props
    return (
      this.state.showNotices &&
      <div id="system-bullet-screen" onTransitionEnd={this.removeSystemNotices} ref={el => this.sysNotice = el}>
        <img className='avatar'
             src='https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/system-notice-icon.png' alt=""/>
        <div className='sys-bullet-screen-swiper-container'>
          <ul className="swiper-wrapper">
            {
              (bullets && bullets.length) ? bullets.map((item, index) => {
                  return (
                    <li className="swiper-slide" key={index}>
                      <span>{item}</span>
                    </li>
                  )
                })
                : null
            }
          </ul>
        </div>
      </div>

    )
  }
}

export default SystemBulletScreen
