import React, { Component } from 'react'
import './video-catalog.scss'
import { Link } from "react-router-dom";
import classnames from 'classnames'


class VideoCatalog extends Component {

    handleClick = (i) => {
        this.props.selectVideo(i)
    }

    render() {
        return (
            <div className='video-catalog'>
                <ul>
                    {
                        this.props.videoCatalog.map((item, index) => {
                            return (
                                <li
                                    key={item.id}
                                    className={classnames({active: this.props.activeIndex === index})}
                                >
                                    <div
                                        className="video-title"
                                        onClick={this.handleClick.bind(this, index)}
                                    >
                                        <span className="title text-overflow-2">{item.name}</span>
                                        {/*<span className='duration'>{item.duration}</span>*/}
                                        <i className={classnames(`iconfont`,
                                            [item.video_auth === 0
                                                ? 'iconiconfront-74'
                                                : 'iconplay_hovericon'],
                                        )}/>
                                    </div>
                                    {
                                        this.props.isAist ? (
                                            item.video_auth ? (
                                                (item.practice && item.practice.qid)
                                                ? <Link to={{
                                                    pathname: item.practice.is_tested ? '/campResolve' : '/campTest',
                                                    search: `?keshi_id=${item.id}&qid=${item.practice.qid}`,
                                                    state: {from: `/play/video${window.location.search}`}
                                                }}>
                                                    <div className="exercise">
                                                        <span className={'text-overflow-one'}>课后练习：{item.practice.title}</span>
                                                        <i className={classnames('iconfont', item.practice.is_tested ? 'iconiconfront-3' : '')}/>
                                                    </div>
                                                </Link>
                                                : null
                                            ) : (
                                                <a href="javascript:void(0)">
                                                    <div className="exercise">
                                                        <span className={'text-overflow-one'}>课后练习：{item.practice.title}</span>
                                                        <i className={classnames('iconfont','iconiconfront-74')}/>
                                                    </div>
                                                </a>
                                            )
                                        ) : (
                                            item.practice_common.map((commonItem, index) => {
                                                return (
                                                    item.video_auth ? (
                                                        <Link to={{
                                                            pathname: commonItem.is_tested ? '/campResolve' : '/campTest',
                                                            search: `?keshi_id=${item.id}&qid=${commonItem.qid}`,
                                                            state: {from: `/play/video${window.location.search}`}
                                                        }} key={index}>
                                                            <div className="exercise">
                                                                <span className={'text-overflow-one'}>课后练习：{commonItem.title}</span>
                                                                <i className={classnames('iconfont',commonItem.is_tested ? 'iconiconfront-3' : '')}/>
                                                            </div>
                                                        </Link>
                                                    ) : (
                                                        <a href="javascript:void(0)">
                                                            <div className="exercise">
                                                                <span className={'text-overflow-one'}>课后练习：{commonItem.title}</span>
                                                                <i className={classnames('iconfont','iconiconfront-74')}/>
                                                            </div>
                                                        </a>
                                                    )
                                                )
                                            })
                                        )
                                    }
                                </li>
                            )
                        })
                    }
                </ul>
            </div>
        );
    }
}

export default VideoCatalog;