import React, { Component } from 'react';
import './index.scss'
import { HeaderBar, CallApp, CaptchaAli } from "@common/index"
import { browser, getParam, http } from "@/utils"
import { Toast } from "antd-mobile";
import { Link } from 'react-router-dom'


class Problems extends Component {

  state = {
    isShowAnswer: false,
    isShowCaptcha: false,
    instance: null,
    problem: {},
  }

  componentDidMount() {
    this.getProblem()
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevProps.match.params.id !== this.props.match.params.id) {
      this.setState({
        problem: {},
        isShowAnswer: false,
      });
      this.getProblem()
    }
  }


  onVerify = data => {
    http.post(`${API.home}/m/safety`, data)
      .then(res => {
        const {code} = res.data
        if (code === 200) {
          this.setState({
            isShowCaptcha: false,
          })
          this.getProblem()
        } else {
          this.state.instance && this.state.instance.reset()
        }
      })
  }

  getInstance = (instance) => {
    this.setState({
      instance,
    });
  }

  getProblem = () => {
    http.get(`${API.home}/m/question/${this.props.match.params.id}`)
      .then(res => {
        const {code, msg, data} = res.data
        if (code === 200) {

          this.setState({
            problem: data,
          });

        } else if (code === 1) {
          this.setState({
            isShowCaptcha: true,
          });
        } else {
          Toast.info(msg)
        }
      })
  }

  goBack = () => {
    if (document.referrer.includes(API.www)) {
      history.go(-1)
    } else {
      const {state, hash} = this.props.location
      if (hash.includes('goback')) {
        return window.history.go(-1)
      }
      if (browser.isWeixin && getParam('code') && getParam('state')) {
        window.history.go(-2)
      }
      if (state.records && state.records.length > 1) {
        window.history.go(-1);
      } else if (state.from && state.from.pathname) {
        location.replace(`${state.from.pathname}${state.from.search}`)
      } else {
        window.location.href = window.location.origin
      }
    }
  }


  render() {
    const {isShowAnswer, problem: {quesInfo, between}, isShowCaptcha} = this.state
    return (
      quesInfo || isShowCaptcha ? <article id={'problems'}>
        {
          !isShowCaptcha ?
            <>
              <HeaderBar title={quesInfo && quesInfo.category} arrow={true} cart={false}
                         goBack={this.goBack}></HeaderBar>
              <div className="topic">
                <span>{quesInfo && quesInfo.order_id}.</span>
                <span dangerouslySetInnerHTML={{__html: quesInfo && quesInfo.ques}}></span>
              </div>
              {
                !isShowAnswer &&
                <div className="btn" onClick={() => {
                  this.setState({
                    isShowAnswer: true,
                  });
                }}>
                  <button>查看解析 <i className={'iconfont iconiconfront-69'}></i></button>
                </div>
              }
              {
                isShowAnswer &&
                <div className={`content`}>
                  <div className={'title'}>解析</div>
                  <span dangerouslySetInnerHTML={{__html: quesInfo.analysis}}></span>
                </div>
              }
              <footer>
                <div className="app">更多题目请 <CallApp text={'前往APP'}/></div>
                <div className="op">
                  {
                    between && !!between.up && <Link to={`/problems/${between.up}`} replace className={'nav'}>上一题</Link>
                  }
                  {
                    between && !!between.down &&
                    <Link to={`/problems/${between.down}`} replace className={'nav'}>下一题</Link>
                  }
                </div>
              </footer>
            </>
            : <div className="captcha-container">
              <div>亲，系统正忙，滑动一下马上回来</div>
              <CaptchaAli getInstance={this.getInstance} onVerify={this.onVerify}/>
            </div>
        }
      </article> : null

    );
  }
}

export default Problems;