import React from 'react';
import './header.scss';

export default (props) => {
  const { title, isDecorate = true, headerStyle = {} } = props;
  return (
    <>
      <div className="college-header" style={headerStyle}>
        <i className="college-header__icon" data-direction="left"></i>
        <h2 className="college-header__text">{title}</h2>
        <i className="college-header__icon" data-direction="right"></i>
      </div>
      {
        isDecorate &&
        <i className="college-header__decorate"></i>
      }
    </>
  );
};
