import React, {Component} from 'react'
import './index.scss'
import {http, SendMessageToApp, getParam} from '@/utils'
import CommonContainer from './../common/commonContainer/index'
import CourseItem from '../../../blessingPreheat/courseItem/index'
import {withRouter} from "react-router-dom"
import { connect } from 'react-redux';

@connect(({user}) => ({
    user
}))
class YarnWish extends Component {
    state = {
        list: [],
        activityStage: 1,
    }

    componentDidMount() {
        this.fetchCourse()
        this.getStage()
    }

    componentWillUpdate() {
        const {activityStage} = this.state
        if (activityStage == 1) {
            document.title = `粽子节，开宝箱免费学AI课程，现金红包，京东购物卡送不停！-七月在线`
        } else {
            document.title = `粽子节，开宝箱免费学AI课程，现金红包，京东购物卡送不停！-七月在线`
        }
    }

    fetchCourse = () => {
        http.get(`${API.home}/activity/wish_course`).then(res => {
            const {code, data} = res.data
            if (code === 200) {
                this.setState({
                    list: JSON.stringify(data) === '{}' ? [] : data
                })
            } else if (code === 4030) {
                this.props.history.push('/passport/login')
            }
        })
    }

    getStage = () => {
        http.get(`${API.home}/activity/stage`).then(res => {
            const {code, data} = res.data
            if (code === 200) {
                if(Number(data.activity_stage) === 0) {
                    this.props.history.push('/');
                    return;
                    
                }
                this.setState({
                    activityStage: data.activity_stage  // 0-不在活动时间 1-预热 2-正式 3-返场
                })
            }
        })
    }

    // 去课程详情页
    toCourse = (courseId) => {
        const {history} = this.props
        if (!getParam('version')) {
            history.push(`/detail?id=${courseId}`)
        } else {
            SendMessageToApp("toCourse", courseId)
        }
    }

    toInviteFriends = (oid, params = {}) => {
        const { history } = this.props
        if (getParam('version')) {
            let data = {
                title: `【仅剩${params.number}个名额】我${params.price}元拼了《${params.course_title}》`,
                desc: params.course_title,
                link: `${API.m}/togroup?id=${oid}`,
                imgUrl: params.image_name,
            }
            SendMessageToApp("toShare", data)
        } else {
            history.push(`/togroup?id=${oid}`);
        }
    }

    toContinueBargain = (id, price, code, image) => {
        const { history } = this.props;
        if(getParam('version')) {
            let data = {
                title: '我发现一门好课，快来帮我砍价吧！',
                desc: `我已经砍了${price}元，看看你能砍多少`,
                link: `${API.m}/bargain-middle-page?id=${id}&bargaincode=${code}&is_originator=1`,
                imgUrl: image,
            }
            SendMessageToApp("toShare", data)
        }else {
            history.push(`/bargain-middle-page?id=${id}&bargaincode=${code}&is_originator=1`);
        }
    }

    toCart = (id) => {
        const { history } = this.props;
        http.post(`${API.home}/m/cart/add`, {
            course_id: id
        }).then((res) => {
            const { code, msg } = res.data;
            // code 15001 已加入购物车
            if (code === 200 || code === 15001) {
                if(getParam('version')) {
                    SendMessageToApp('toShoppingCart')
                }else {
                    history.push('/shopcart');
                }
            } else if (code === 4030 || code === 4040) {
                this.toLogin();
            } else {
                Toast.info(msg, 2);
            }
        })
    }

    // 砍完价去支付
    bargainToOrder = (id) => {
        console.log(this.props);
        const { history, user } = this.props;
        if(user.hasError) {
            this.toLogin();
        }else{
            if(getParam('version')) {
                SendMessageToApp('toPay', id)
            }else {
                http.get(`${API['base-api']}/m/cart/addtopreorder/[${id}]`).then((res) => {
                    const { errno, msg } = res.data;
                    if (errno === 0) {
                        history.push(`/order?id=[${id}]`, {bargain: 1});
                    } else {
                        Toast.info(msg, 2);
                    }
                })
            }
        }
    }

    render() {
        const { list, activityStage } = this.state
        console.log(activityStage);
        return (
            <div className='year-wish'>
                <div className="banner">
                    <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/xy_banner_bj.png" alt=""/>
                </div>

                {
                    list.length > 0
                    ? <>
                        {
                            activityStage !== 1 &&
                            <>

                                <CommonContainer>
                                    <div className='groupcourse course-box'>
                                        {
                                            list.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    time={item.type === 2 || item.type === 7? item.end_time : ''}
                                                    toCourse={this.toCourse}
                                                >
                                                    {/*
                                                      * 拼团，正常：未开团1 已开2；一分：未开团5 已开7
                                                      * type 1 立即参团 2 已参团 3 我要砍价 4 已参加砍价 可以继续砍价 5 马上抢 6 开始学习 7 已参加一分钱拼团 8 砍价待支付
                                                    */}

                                                    <div className="coupon-course__footer">

                                                        {
                                                            (item.type === 4 || item.type === 8) &&
                                                            <div className="bargain-price">已砍{item.already_bargain}元</div>
                                                        }

                                                        {
                                                            item.type === 0 &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag" data-color="green">活动价</span>
                                                                </div>
                                                                <div className="price price-group">
                                                                    <span className="price-label">¥</span>
                                                                    <span className="new-price">{item.original_price}</span>
                                                                    <span className="old-price">
                                                                        <s>¥{item.original_price}</s>
                                                                    </span>
                                                                </div>
                                                            </>
                                                        }
                                                        {
                                                            (item.type === 1 || item.type === 2) &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag" data-color="green">拼团价</span>
                                                                </div>
                                                                <div className="price price-group">
                                                                    <span className="price-label">¥</span>
                                                                    <span className="new-price">{item.pdd_price}</span>
                                                                    <span className="old-price">
                                                                        <s>¥{item.original_price}</s>
                                                                    </span>
                                                                </div>
                                                            </>
                                                        }
                                                        {
                                                            (item.type === 5 || item.type === 7) &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag" data-color="green">拼团价</span>
                                                                </div>
                                                                <div className="price price-group">
                                                                    <span className="price-label">¥</span>
                                                                    <span className="new-price">0.01</span>
                                                                    <span className="old-price">
                                                                        <s>¥{item.original_price}</s>
                                                                    </span>
                                                                </div>
                                                            </>
                                                        }
                                                        {
                                                            (item.type === 3 || item.type === 4 || item.type === 8) &&
                                                            <>
                                                                <div className="type">
                                                                    <span className="tag" data-color="green">好友帮帮砍</span>
                                                                </div>
                                                                <div className="price price-group">
                                                                    <span className="price-label">到手最低：¥</span>
                                                                    <span className="new-price">{item.low_prize}</span>
                                                                    <span className="old-price">
                                                                        <s>¥{item.original_price}</s>
                                                                    </span>
                                                                </div>
                                                            </>
                                                        }
                                                        {
                                                            item.type === 6 &&
                                                            <p className={'course-title text-overflow-1'}>
                                                                {item.course_title}
                                                            </p>
                                                        }

                                                        <div className="status" data-layout={item.type === 4? 'row' : ''}>
                                                            {
                                                                item.type === 0 &&
                                                                <a
                                                                    onClick={() => this.toCart(item.course_id)}
                                                                    className="status-btn to-group"
                                                                >立即购买</a>
                                                            }
                                                            {
                                                                item.type === 1 &&
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="status-btn to-group"
                                                                >立即参与拼团</a>
                                                            }
                                                            {
                                                                (item.type === 2 || item.type === 7) &&
                                                                <a
                                                                    onClick={() => this.toInviteFriends(item.order_id, {
                                                                        number: item.number,
                                                                        course_title: item.course_title,
                                                                        image_name: item.image_name,
                                                                        price: item.type === 2? item.pdd_price : 0.01
                                                                    })}
                                                                    className="status-btn to-group"
                                                                    data-status="done"
                                                                >已参团，邀请好友参团</a>
                                                            }
                                                            {
                                                                item.type === 3 &&
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="status-btn to-group"
                                                                >我要砍价</a>
                                                            }
                                                            {
                                                                item.type === 4 &&
                                                                <>
                                                                    <a
                                                                        onClick={() => this.toContinueBargain(item.course_id, item.already_bargain, item.bargain_code, item.image_name)}
                                                                        className="status-btn to-group"
                                                                    >继续砍价</a>
                                                                    <a
                                                                        onClick={() => this.bargainToOrder(item.course_id)}
                                                                        className="status-btn to-group"
                                                                    >支付{item.actual_payment}元</a>
                                                                </>
                                                            }
                                                            {
                                                                item.type === 8 &&
                                                                <a
                                                                    onClick={() => this.bargainToOrder(item.course_id)}
                                                                    className="status-btn to-group"
                                                                >支付{item.actual_payment}元</a>
                                                            }
                                                            {
                                                                item.type === 5 &&
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="status-btn to-group"
                                                                >马上抢>></a>
                                                            }
                                                            {
                                                                item.type === 6 &&
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-group"
                                                                    data-status="study"
                                                                >开始学习</a>
                                                            }
                                                        </div>
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                </CommonContainer>
                            </>
                        }
                        {
                            activityStage === 1 &&
                            <>
                                <CommonContainer>
                                    <div className='groupcourse course-box'>
                                        {
                                            list.map(item => (
                                                <CourseItem
                                                    image={item.image_name}
                                                    key={item.course_id}
                                                    id={item.course_id}
                                                    toCourse={this.toCourse}
                                                >
                                                    {
                                                        item.type == 4 && item.is_buy != 1 &&
                                                        <div className="group-num">限量300个</div>
                                                    }
                                                    <div className="coupon-course__footer">
                                                        {
                                                            item.is_buy == 1 &&
                                                            <>
                                                                <p className={'course-title text-overflow-1'}>{item.course_title}</p>
                                                                <a
                                                                    onClick={() => this.toCourse(item.course_id)}
                                                                    className="btn to-study"
                                                                >开始学习</a>
                                                            </>
                                                        }
                                                        {
                                                            item.is_buy == 0 &&
                                                            <>
                                                                <div className="type">
                                                                    {
                                                                        item.type == 0 &&
                                                                        <>
                                                                            <span className="tag">活动价</span>
                                                                            <span className="time">12.23开始</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        (item.type == 1 || item.type == 4) &&
                                                                        <>
                                                                            <span className="tag">拼团价</span>
                                                                            <span className="time">12.23开团</span>
                                                                        </>
                                                                    }
                                                                    {
                                                                        item.type == 2 &&
                                                                        <>
                                                                            <span className="tag">好友帮帮砍</span>
                                                                            <span className="time">12.23开砍</span>
                                                                        </>
                                                                    }
                                                                </div>
                                                                <div className="price">
                                                                    {item.type == 2 ? '到手最低:¥' : '¥'}
                                                                    <span
                                                                        className="new-price">{item.type == 4 ? '0.01' : item.price2}</span>
                                                                    <span className="old-price">{item.type == 2 ? '' : '现价：'}<s>¥{item.price1}</s></span>
                                                                </div>
                                                                <div className="status">
                                                                    <a
                                                                        onClick={() => this.toCourse(item.course_id)}
                                                                        className="status-btn to-buy"
                                                                    >直接购买</a>
                                                                    {
                                                                        item.is_join == 1 &&
                                                                        <a className="status-btn add-wish">
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/add-success.png"
                                                                                alt=""
                                                                            />
                                                                            已加心愿单
                                                                        </a>
                                                                    }
                                                                    {
                                                                        item.is_join == 0 &&
                                                                        <a
                                                                            onClick={() => this.addWishList(item.course_id)}
                                                                            className="status-btn add-wish-success"
                                                                        >
                                                                            <img
                                                                                src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/like_icon.png"
                                                                                alt=""
                                                                            />
                                                                            加入心愿单
                                                                        </a>
                                                                    }
                                                                </div>
                                                            </>
                                                        }
                                                    </div>
                                                </CourseItem>
                                            ))
                                        }
                                    </div>
                                </CommonContainer>
                            </>
                        }
                    </>
                    : (
                        <div className="notData">
                            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/PC/icon-empty.png" alt=""/>
                            {
                                activityStage == 1
                                ? <p>你的心愿单目前空空如也，<br/>快去挑选更多优惠课程吧～</p>
                                : <p>你的心愿单没有课程哦，<br/>感兴趣的课程可在双旦主会场直接购买！</p>
                            }
                        </div>
                    )
                }
            </div>
        )
    }
}

export default withRouter(YarnWish)
