import React from 'react';
import './prize.scss';

export default (props) => {
  const { 
    data: {
      bind_phone, 
      bind_address, 
      prize_type,
    },
    handleToBindPhone,
    handleToBindAddress,
    toComposeCoupon,
    toUseCoupon,
    toCourseList,
    toFecthMoney,
  } = props;
  return (
    <>
      {/* 第一：是否需要绑定手机号 */}
      {
        bind_phone &&
        <a className="team-result" onClick={handleToBindPhone}>
          <span>绑定手机号</span>
        </a>
      }

      {/* 第二：是否需要填写地址 */}
      {
        (!bind_phone && bind_address) &&
        <a className="team-result" onClick={handleToBindAddress}>
          <span>查看/修改收货信息</span>
        </a>
      }

      {/* 第三：奖品，实物 */}
      {
        (!bind_phone && !bind_address && prize_type === 1) &&
        <a className="team-result" onClick={handleToBindAddress}>
          <span>查看/修改收货信息</span>
        </a>
      }

      {/* 第三：奖品，代金券碎片 */}
      {
        (!bind_phone && !bind_address && prize_type === 6) &&
        <a className="team-result" onClick={toComposeCoupon}>
          可合成代金券在购课时使用，
          <span>去合成</span>
        </a>
      }

      {/* 第三：奖品，指定课程代金券 */}
      {
        (!bind_phone && !bind_address && prize_type === 3) &&
        <a className="team-result" onClick={toUseCoupon}>
          已发放至您的账户，
          <span>去使用</span>
        </a>
      }

      {/* 第三：奖品，通用课程代金券 */}
      {
        (!bind_phone && !bind_address && prize_type === 4) &&
        <a className="team-result" onClick={toCourseList}>
          已发放至您的账户，
          <span>去使用</span>
        </a>
      }

      {/* 第三：奖品，现金红包 */}
      {
        (!bind_phone && !bind_address && prize_type === 7) &&
        <a className="team-result" onClick={toFecthMoney}>
          已存入您的账户，
          <span>去提现</span>
        </a>
      }

      {/* 第三：奖品，线上课程 */}
      {
        (!bind_phone && !bind_address && prize_type === 2) &&
        <a className="team-result">已发放至您的账户</a>
      }

      {/* 第三：奖品，任意线上课程兑换券 */}
      {
        (!bind_phone && !bind_address && prize_type === 5) &&
        <a className="team-result">无法领取请添加微信：julyedukefu10
        </a>
      }
    </>
  )
}