import React, { Component } from 'react';
import { Switch, Route } from "react-router-dom";
import Anniversary2020 from "@components/activity/2020-717/activity"
import Question from "@components/activity/2020-717/question"
import Invitation from "@components/activity/2020-717/invitation"


class Anniversary2020Entry extends Component {
  render() {
    const match = this.props.match
    return (
      <Switch>
        <Route path={`${match.path}/question/:isPractice?`}
               render={routeProps => (<Question {...routeProps}></Question>)}></Route>
        <Route path={`${match.path}/invitation`} render={routeProps => (<Invitation {...routeProps}/>)}></Route>
        <Route path={'/anniversary_2020'}
               render={routeProps => (<Anniversary2020 {...routeProps}></Anniversary2020>)}></Route>
      </Switch>
    );
  }
}

export default Anniversary2020Entry;