import React, {Component} from 'react';
import './index.scss';
import {HeaderBar, VList} from '@/common';
import {http, getParam, SendMessageToApp} from '@/utils';
import {Toast} from 'antd-mobile';


class ShareCourse extends Component {

    constructor(props) {
        super(props);
        this.state = {
            list: [],
            fromApp: !getParam('from') ? false : true
        };
    }

    componentDidMount() {
        http.get(`${API.home}/sys/red_packet/share_course`).then((res) => {
            if (res.data.code === 200) {
                this.setState({
                    list: res.data.data
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    toCourseDetail = (id) => {
        const _this = this
        if (_this.state.fromApp) {
            SendMessageToApp("toCourse", id)
        } else {
            const {history} = this.props;
            history.push(`/detail?id=${id}`)
        }
    }

    render() {
        const {list} = this.state;
        return (
            <div className={'share-course'}>
                {
                    !this.state.fromApp &&
                    <HeaderBar title='分享领红包' arrow={true}/>
                }

                {
                    list && list.length > 0 ? <div>
                            {
                                list.map((item, index) => {
                                    const Info = (
                                        <div className="info">
                                            <p className={'title text-overflow-1'}>{item.course_title}</p>
                                            <p className={'contact text-overflow-1'}>{item.simpledescription}</p>
                                            <button>分享领红包</button>
                                        </div>
                                    )
                                    return (
                                        <div key={index}>
                                            <VList
                                                img={item.image_name}
                                                info={Info}
                                                id={item.course_id}
                                                toDetail={this.toCourseDetail}
                                            />
                                        </div>

                                    )
                                })
                            }
                        </div> :
                        <div>
                            <p className='not-data'>暂时没有可分享的课程哦〜</p>
                        </div>
                }

            </div>
        )
    }
}

export default ShareCourse;
