import React, { Component } from 'react'
import './index.scss'

export default class Study extends Component {
  render() {
    return (
      <div className={'study__container'}>
        <img className={'learn_left'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/learn_left.png" alt=""/>
        <img className={'learn_bottom'} src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/learn_bottom.png" alt=""/>
        <p className={'title'}>阶 / 梯 / 学 / 习</p>
        <p className={'sub__title'}>20节课堂教学，带你掌握Python技术入门知识</p>
        <div className={'step__container'}>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/wanzheng.png" alt=""/>
            <p>完整的Python基础知识体系</p>
            <div className={'item__line'}></div>
          </div>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/siwei.png" alt=""/>
            <p>灵活的编程思维和实操技巧</p>
            <div className={'item__line'}></div>
          </div>
          <div className={'item__container'}>
            <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/shicao.png" alt=""/>
            <p>丰富有趣的实操训练</p>
          </div>
        </div>

        <div className={'table__container'}>
          <div className={'table__head'}>
            <div className={'head_title order_number'}>序号</div>
            <div className={'head_title chapter'}>章节</div>
            <div className={'head_title points'}>知识点</div>
          </div>
          <div className={'table__body'}>
            {
              this.props.syllabus.map((item, index)=>{
                return (
                  <div className={'item__container'} key={index}>
                    <div className={'item__title'}>{item.name}</div>
                    {
                      item.lessons.map((item, index)=>{
                        return (
                          <div className={'item__content'} key={index}>
                            <div className={'content order_number number_center'}>{item.number}</div>
                            <div className={'content chapter'}>{item.number}</div>
                            <div className={'content points'}>{item.info.name}</div>
                          </div>
                        )
                      })
                    }
                  </div>
                )
              })
            }
          </div>
          <div className={'table__bottom'}>
            {
              this.props.allSyllabusShow ? (
                <div onClick={() => this.props.hide(1)}>
                  <p>收起</p>
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/shouqi.png" alt=""/>
                </div>
              ) : (
                <div onClick={() => this.props.show(1)}>
                  <p>展开更多</p>
                  <img src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/h5_python_class/zhankai.png" alt=""/>
                </div>
              )
            }
          </div>
        </div>
      </div>
    )
  }
}
