import React, {PureComponent} from 'react'
import './index.scss'
import {connect} from "react-redux"
import {Toast} from 'antd-mobile'
import {http} from "@/utils"
import {HeaderBar} from "@/common"
import {logout, updateUser} from '@/store/userAction'
import {compose} from "redux";
import {WithFullSize} from '@/HOCs'

class MyEdut extends PureComponent {
    constructor(props) {
        super(props)
        this.state = {
            isShow: false,
            value: ''
        }
    }

    // 点击编辑
    toEditName = (name) => {
        this.setState({
            isShow: true,
            value: name
        })
    }
    // 取消
    cancle = () => {
        this.setState({
            isShow: false
        })
    }

    // 获取input的值
    handleChange = (e) => {
        this.setState({
            value: e.target.value
        })
    }
    // 退出登录
    outLogin = () => {
        this.props.logout()
        Toast.info('已退出', 2, null, false)
        this.props.history.push('/my')
    }

    // 确定修改
    submit = () => {
        if (this.state.value.length > 12) {
            Toast.info('不超过12个字符', 2)
        } else if (this.state.value.length === 0) {
            Toast.info('请输入昵称', 2)
        } else {
            let data = {
                user_name: this.state.value
            }
            http.post(`${API.home}/m/user_info/update`, data).then((res) => {
                if (res.data.code === 200) {
                    this.setState({
                        isShow: false
                    })
                    this.props.updateUser({data: {username: this.state.value}})
                    Toast.info('修改成功', 2)
                } else if (res.data.code === 4008) {
                    this.setState({
                        isShow: false
                    })
                } else {
                    Toast.info(res.data.msg, 2)
                }

            })
        }
    }

    render() {
        const {user} = this.props
        const username = user && user.data && user.data.username
        const avatar = user && user.data && user.data.avatar
        return (
            <div className="edit-name">
                <HeaderBar title='账号' arrow={true} cart={false}></HeaderBar>

                <div className='my-mess'>
                    <img src={avatar} alt=""/>
                    <span className="name">{username}</span>
                    <span onClick={this.toEditName.bind(this, username)} className="edit">编辑</span>
                </div>
                <div className="out-login" onClick={this.outLogin}>
                    退出登录
                </div>

                {
                    this.state.isShow &&
                    <div className="edit-mbc">
                        <div className="edit-content">
                            <div className="edit-title">修改昵称</div>
                            <input type="text" placeholder='请输入昵称（不超过12个字符）'
                                   value={this.state.value}
                                   onChange={this.handleChange.bind(this)}
                            />
                            <div className="edit-btn">
                                <button className='cancle' onClick={this.cancle}>取消</button>
                                <button className='submit' onClick={this.submit}>确认</button>
                            </div>
                        </div>
                    </div>
                }
            </div>
        )
    }

}

export default compose(
    connect(
        state => ({user: state.user}),
        {logout, updateUser}
    ),
    WithFullSize
)(MyEdut)
