import React, { Component } from 'react'
import './index.scss'
import {http} from "@/utils"
import ListHeader from './../listHeader';

export default class RankList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      rankList: []
    }
  }

  componentDidMount() {
    http.get(`${API.home}/sys/ai_test/ranking/50`).then(res => {
      let data = res.data.data;
      let code = res.data.code;
      if(code === 200) {
        this.setState({
          rankList: data.rankings
        })
      }
    });
  }

  formart = (time) => {
    let date = time * 1000,
      hours = 0,
      minutes = 0,
      seconds = 0;
    hours = `${parseInt(date / (60 * 60 * 1000))}`.padStart(2, 0);
    minutes = `${parseInt((date - hours * 3600000) / 60000)}`.padStart(2, 0);
    seconds = `${parseInt(
      (date - hours * 3600000 - minutes * 60000) / 1000
    )}`.padStart(2, 0);
    return `${minutes}'${seconds}"`;
  }

  render() {
    let {rankList} = this.state;
    return (
      <>
      <ListHeader text="测试排行榜" styles={{margin: '20px 0 10px'}} size='middle' />
      <div className="sort__rules">
        仅显示前50名
      </div>
      <div className="rank__list_module">
        <div className="rank__table_head">
          <div className="table_head table_head__sort">排名</div>
          <div className="table_head table_head__user_info">用户</div>
          <div className="table_head table_head__time">用时</div>
          <div className="table_head table_head__score">成绩</div>
          <div className="table_head table_head__prize">奖品</div>
        </div>
        <div className="rank__table_body">
          {
            rankList.map((item, index)=>{
              return (
                <div className="table__tr" key={index}>
                  <div className='table__body table_head__sort'>
                    {
                      index > 2 ? (index + 1) : (
                        null
                      )
                    }
                  </div>
                  <div className='table__body table_head__user_info'>
                    <img className="user__avatar" src={item.avatar} />
                    <span className="user__name">{item.user_name}</span>
                  </div>
                  <div className='table__body table_head__time'>{this.formart(item.cost_time)}</div>
                  <div className='table__body table_head__score'>{item.score}</div>
                  <div className='table__body table_head__prize'>{item.prize}</div>
                </div>
              )
            })
          }
        </div>
      </div>
      </>
    )
  }
}
