import React, { Component } from 'react';
import ReactDOM from 'react-dom';
import './mask.scss';

const Root = document.querySelector('body');

class Mask extends Component {

  constructor(props) {
    super(props);
    if(!this.el) {
      this.el = document.createElement('div');
    }
  }

  componentDidMount() {
    Root.appendChild(this.el);
  }

  componentWillUnmount() {
    Root.removeChild(this.el);
  }

  render() {
    const { visible, handleToHide } = this.props;
    if(visible) {
      return ReactDOM.createPortal(
        (
          <div className="mask">
            <div className="mask-content">
              {this.props.children}
            </div>
            <div className="mask-footer">
              <i className="mask-button__close" onClick={handleToHide}></i>
            </div>
          </div>
        ),
        this.el
      );
    }else {
      return null;
    }
  }
}

export default Mask;