import React from 'react';
import './index.scss';

export default (props) => {
  console.log(props);
  const { 
    data: {
      team_num = 1,
      lack_member = 4,
      member = [],
    },
    handleToInvite
  } = props;
  const members = new Array(5).fill({});
  return (
    <div className="team-success">
      <h2 className="team-success__title">创建成功</h2>
      <p className="team-success__tip">
        {<span>{team_num}</span>}号队伍 还差{<span>{lack_member}</span>}名队员即可获得宝箱哦~
      </p>
      <i className="team-success__icon"></i>
      <ul className='team-success__member members'>
        {
          members.map((item, index) => {
            const _member = member[index]
            return (
              <li className="member-item" key={index}>
                {
                  _member && _member['is_captain'] && <sup className="member-item__captain">队长</sup>
                }
                <img
                  className="member-item__avatar"
                  src={
                    _member
                      ? _member['head_img']
                      : "https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/newyear20/H5/not-joined-placeholder.png"
                  }
                  alt=""/>
              </li>
            );
          })
        }
      </ul>
      <button type={'button'} className="team-success__button" onClick={handleToInvite}>邀请好友加入队伍</button>
    </div>
  )
}