import React, {Component} from 'react';
import './index.scss';
import {http, getParam} from '@/utils';
import QRCode from 'qrcode';
import {connect} from "react-redux";
import {Toast} from 'antd-mobile';

class FollowQRcode extends Component {

    constructor(props) {
        super(props);
        this.state = {
            src: '',
            codeSrc: ''
        };
    }

    componentDidMount() {
        const _this = this
        let uid = this.props && this.props.user && this.props.user.data.uid
        http.get(`${API['base-api']}/wx/user_temporary_qrcode/${uid}`).then((res) => {
            if (res.data.errno == 0) {
                _this.setState({
                    src: res.data.data.url
                })
                return new Promise(resolve => {
                    QRCode.toDataURL(_this.state.src, {}, function (err, url) {
                        _this.setState({
                            codeSrc: url
                        })
                    })
                    resolve()
                })
            } else {
                Toast.info(res.data.msg, 2)
            }
        })
    }

    render() {
        return (
            <div className='followQRcode-box'>
                <div className='followQRcode'>
                    <div className="content">
                        <p className="title">关注公众号</p>
                        <p className='desc'>
                            <span>1</span>有人通过您分享的链接领取红包后，会第一时间通过微信服务号通知您。
                        </p>
                        <p className='desc'>
                            <span>2</span>请用个人微信扫描，关注服务号后可提现红包到微信零钱。
                        </p>
                        <img src={this.state.codeSrc} alt=""/>
                        <p className="tip">长按二维码保存到相册</p>
                    </div>
                    <div className='close'>
                        <i className='iconfont iconiconfront-2' onClick={this.props.toClose}></i>
                    </div>
                </div>
            </div>
        )
    }
}

export default connect(
    state => ({
        user: state.user
    })
)(FollowQRcode)

