import React, {Component} from 'react'
import './index.scss'
import {connect} from "react-redux"
import {withRouter} from 'react-router-dom'
import {compose} from "redux"

class Deposit extends Component {
    constructor(props) {
        super(props)
        this.state = {}
    }

    render() {
        const {courseInfo} = this.props;
        let info = ''
        if (courseInfo) {
            info = courseInfo.deposit_info
        }
        return (
            <div className="buy-expand">
                <p className="buy-time">付定金时间：{info.deposit_start_time}-{info.deposit_end_time}</p>
                <p className="buy-time">付尾款时间：{info.final_start_time}-{info.final_end_time}</p>
                <div className="expand-bgimg">
                    <img
                        className="four-year"
                        src="https://julyedu-cdn.oss-cn-beijing.aliyuncs.com/active19_1111/m/dj-1111.png"
                        alt=''
                    />
                    <span className="dingjin">定金{info.deposit_amount}元，可抵扣{info.deduction_amount}元</span>
                    <p className="small">
                        到手价最低：¥
                        <span>{info.low_price}</span>
                    </p>
                    <p className="else-tip">另可获得最高{info.deposit_coupon}元代金券进行叠加</p>
                </div>
            </div>
        );
    }
}

export default compose(
    connect(
        state => ({
            user: state.user
        }),
        null
    ),
    withRouter
)(Deposit)
