import React, { Component } from "react"
import "./datum-catalog.scss"
import { Accordion } from "antd-mobile"

class DatumCatalog extends Component {
  static defaultProps = {
    datum: [
      {
        dir_name: "",
        files: [
          {
            file_name: "",
            file_id: 0,
          },
        ],
      },
    ],
  }

  render() {
    const { datum } = this.props
    return (
      <div className="datum-catalog">
        <p className="prompt">课程资料请到PC端播放页下载</p>
        <Accordion>
          {datum &&
            datum.length &&
            datum.map((item, index) => {
              return (
                <Accordion.Panel header={item.dir_name} key={index}>
                  {item.files.map((item) => {
                    return (
                      <div key={item.file_id} className="file-name">
                        {item.file_name}
                      </div>
                    )
                  })}
                </Accordion.Panel>
              )
            })}
        </Accordion>
      </div>
    )
  }
}

export default DatumCatalog
