import React, { PureComponent } from "react"
import "./aist-share.scss"
import withFullSize from "src/HOCs/WithFullSize"
import { http, wxShare } from "src/utils"
import { Link } from "react-router-dom"

class AistShare extends PureComponent {
  state = {
    course: {
      title: "",
      des: "",
      img: "",
      id: "",
    },
    progress: {
      days: 0,
      action: 0,
    },
    showShareCover: true,
    user: {
      avatar: "",
      name: "",
      time: "",
    },
  }

  componentDidMount() {
    const search = new URLSearchParams(this.props.location.search)
    http
      .get(
        `${API["base-api"]}/m/aist/share_ground_data/${search.get(
          "id"
        )}/${search.get("vId")}`
      )
      .then((res) => {
        if (res.data.errno === 200) {
          const data = res.data.data
          this.setState({
            course: {
              title: data.course_title,
              des: data.course_desc,
              img: data.image_name,
              id: data.course_id,
            },
            user: {
              avatar: data.avatar,
              name: data.username,
              time: data.create_time,
            },
            progress: {
              days: data.learn_day_num,
              action: data.action_power,
            },
          })
          wxShare({
            title: data.share_title,
            desc: data.share_desc,
            imgUrl: data.image_name,
            link: window.location.href,
          })
        }
      })
  }

  render() {
    const { user, course, progress } = this.state
    return (
      <div className="aist-share">
        <div className="content">
          <div className="user">
            <img src={user.avatar} alt="头像" />
            <span className="username">{user.name}</span>
            <span className="time">{user.time}</span>
          </div>
          <Link
            to={{ pathname: "/detail", search: `?id=${this.state.course.id}` }}
          >
            <div className="course">
              <div className="course-cover">
                <img src={course.img} alt="课程封面" />
              </div>
              <div className="course-info">
                <div className="title">{course.title}</div>
                <div className="des">{course.des}</div>
              </div>
            </div>
          </Link>
          <ul className="progress">
            <li>
              <div className="title">累计学习</div>
              <div className="progress-value">
                <span className="num">{progress.days}</span>天
              </div>
            </li>
            <li>
              <div className="title">行动力超过</div>
              <div className="progress-value">
                <span className="num">{progress.action}</span>%
              </div>
            </li>
          </ul>
          <div className="recommend-app">
            <div className="text">
              <div className="bold">
                <div>立即下载【七月在线】</div>
                <div>众多好课免费学</div>
              </div>
              <div className="light">
                长按识别右侧二维码
                <img
                  src="https://cdn.julyedu.com/active19_717/m/aist/arrow.png"
                  alt=""
                />
              </div>
            </div>
            <div className="qrcode">
              <img
                src="https://cdn.julyedu.com/tinypng-common/right_app.png"
                alt=""
              />
            </div>
          </div>
        </div>
      </div>
    )
  }
}

export default withFullSize(AistShare)
