/* eslint-disable jsx-a11y/anchor-is-valid */
import React, { Component } from "react"
import { WithTab } from "src/HOCs"
import "./index.scss"
import { http } from "src/utils"
import { Link } from "react-router-dom"
import { Toast } from "antd-mobile"
import { HeaderBar } from "src/common"
import Loading from "src/common/Loading"
import { connect } from "react-redux"

@connect()
class Classify extends Component {
  constructor(props) {
    super(props)
    this.state = {
      camp: [],
      employment: [],
      basics: [],
      advanced: [],
      special: [],
      isLoading: true,
    }
  }

  componentDidMount() {
    let data = 1
    http.get(`${API.home}/m/course/classify/${data}`).then((res) => {
      if (res.data.code === 200) {
        this.setState({
          isLoading: false,
        })

        if (res.data.data.common.length > 0) {
          this.setState({
            basics: res.data.data.common[0],
            advanced: res.data.data.common[1] || [],
          })
        }
        if (res.data.data.special.length > 0) {
          this.setState({
            camp: res.data.data.special[0],
            employment: res.data.data.special[1] || [],
            special: res.data.data.special[2] || [],
          })
        }
      } else {
        Toast.info(res.data.msg, 2)
      }
    })
  }

  toCourseDetail = (id) => {
    const { history } = this.props
    history.push(`/detail?id=${id}`)
    return false
  }

  render() {
    return (
      <div className="class-box">
        <HeaderBar title="分类" arrow={false} cart={false}></HeaderBar>
        <Loading isLoading={this.state.isLoading}>
          <ClassCourseBox
            toDetail={this.toCourseDetail}
            data={this.state.camp.list}
            title={this.state.camp.name}
            type={1}
          />
          <ClassCourseBox
            toDetail={this.toCourseDetail}
            data={this.state.employment.list}
            title={this.state.employment.name}
            type={1}
          />
          <ClassCourseBox
            toDetail={this.toCourseDetail}
            data={this.state.basics.list}
            title={this.state.basics.name}
            type={2}
          />
          <ClassCourseBox
            toDetail={this.toCourseDetail}
            data={this.state.advanced.list}
            title={this.state.advanced.name}
            type={2}
          />
          <div className="vip">
            {this.state.special.list &&
              this.state.special.list.length > 0 &&
              this.state.special.list.map((item, index) => {
                return (
                  <a
                    onClick={() => this.toCourseDetail(item.course_id)}
                    key={index}
                  >
                    <img src={item.course_img} alt="" />
                  </a>
                )
              })}
          </div>
        </Loading>
      </div>
    )
  }
}

// 课程图片形式展示 点击图片直接跳转课程详情页面
function ClassCourseA({ data, toDetail }) {
  return (
    <div className="items-box">
      {data &&
        data.length > 0 &&
        data.map((item, index) => {
          return (
            <a
              onClick={() => toDetail(item.course_id)}
              key={index}
              className="item-banner"
            >
              <img src={item.course_img} alt="" />
              {item.is_aist && <span className="return_cash"></span>}
            </a>
          )
        })}
    </div>
  )
}

// 课程标签的形式展示  点击标签跳转分类详情页面
function ClassCourseB(props) {
  return (
    <div className="items-box">
      {props.data &&
        props.data.length > 0 &&
        props.data.map((item, index) => {
          return (
            <Link
              to={`/courselist?id=${item.c_id}&name=${item.c_name}`}
              key={index}
              className="item-label"
            >
              {item.c_name}
            </Link>
          )
        })}
    </div>
  )
}

function ClassCourseBox(props) {
  return (
    <div className="class-course">
      <p className="course-items-title">
        {props.title && <img src={require("./image/tips.png")} alt="" />}
        {props.title}
      </p>
      {props.type === 1 && (
        <ClassCourseA data={props.data} toDetail={props.toDetail} />
      )}
      {props.type === 2 && <ClassCourseB data={props.data} />}
    </div>
  )
}

export default WithTab(Classify)
