import React, { Component } from "react"
import "./index.scss"
import LiveRoom from "./LiveRoom/index"
import YearCourse from "./YearCourse/index"
import TreasureBox from "./../treasure-box/index"
import TreasureNav from "./nav"
import CommonPopup from "./../common/commonPopup/index"
import cookie from "js-cookie"
import { setCurrentUser, startFetchUser } from "src/store/userAction"
import { http } from "src/utils"
import { addDays } from "date-fns"
import { connect } from "react-redux"
import { Toast } from "antd-mobile"

/*eslint-disable*/
@connect(
  (state) => ({
    user: state.user,
  }),
  { setCurrentUser, startFetchUser }
)
class index extends Component {
  state = {
    removable: 0, // 未拆宝箱的数量
    currentOpenId: 0, // 当前要拆的宝箱的队伍的ID
    treasure_stage: 0, // 宝箱的活动阶段
    activity_stage: 0, // 整个活动的阶段
    userInfoList: [],
    userInfo: {},
    isAppUpdate: false,
    showMark: false,
    banner: "https://cdn.julyedu.com/newyear20/new-year/m-banner.png",
  }

  componentDidMount() {
    const _this = this
    // 获取App登录信息
    window["loginInfo"] = (result) => {
      _this.loginInfo(result)
    }
    _this.getStage()
    document.title =
      "AI充电季，开宝箱免费学AI爆款好课，300本程序员必备纸质书免费送，AI进阶宝典来就送！-七月在线"
  }

  // 获取app登录数据
  loginInfo = (result) => {
    this.setState(
      {
        userInfoList: result,
      },
      () => {
        if (this.state.userInfoList.length) {
          this.props.startFetchUser()
          this.appLogin()
        }
      }
    )
  }
  // 保存cookie
  appLogin = () => {
    let expires = addDays(new Date(), 90)
    this.state.userInfoList.map((item, index) => {
      cookie.set("token", item.token, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("plat", item.plat, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("uid", item.uid, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("uname", item.uname, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
      cookie.set("avatar_file", item.avatar_file, {
        expires,
        path: "/",
        domain: ".julyedu.com",
      })
    })

    if (cookie.get("token") && cookie.get("uid")) {
      this.setState({
        isAppUpdate: true,
      })
    }

    this.props.setCurrentUser(this.transformUser(this.state.userInfoList))
  }
  transformUser = (res) => {
    let payload

    res.map((item, index) => {
      payload = {
        hasError: false,
        data: {
          username: item.uname,
          avatar: item.avatar_file,
          token: item.token,
          uid: item.uid,
        },
        isFetching: false,
      }
    })

    return payload
  }

  // 关闭弹框
  closePopup = () => {
    this.setState({
      showMark: false,
    })
  }

  // 获取未拆宝箱数量
  getRemovable = (removable, currentOpenId) => {}

  // 获取活动以及宝箱的阶段
  getStage = () => {
    http.get(`${API.home}/activity/stage`).then((res) => {
      const { code, data, msg } = res.data
      if (code === 200) {
        if (Number(data.activity_stage) === 0) {
          this.props.history.push("/")
          return
        }
        // treasure_stage，宝箱阶段，0-不在活动时间，1-活动时间内
        this.setState({
          activity_stage: data.activity_stage,
          treasure_stage: data.treasure_stage,
        })

        if (data.activity_stage == 3) {
          this.setState({
            banner: "https://cdn.julyedu.com/newyear20/H5/m_banner_fc.png",
          })
        } else {
          this.setState({
            banner: "https://cdn.julyedu.com/newyear20/new-year/m-banner.png",
          })
        }
      } else {
        Toast.info(msg, 2)
      }
    })
  }

  render() {
    const { banner, activity_stage, treasure_stage } = this.state
    return (
      <div className={"year-index"}>
        <div className="banner-treasure">
          <div
            id="banner"
            className="banner-treasure__header"
            style={{ backgroundImage: `url(${banner})` }}
          ></div>
          <div className="banner-treasure__nav">
            <TreasureNav
              id="banner"
              treasure_stage={treasure_stage}
              activeStage={activity_stage}
            />
          </div>
          <div className="banner-treasure__decorate"></div>
        </div>

        {/* 大咖直播 */}
        <LiveRoom isAppUpdate={this.state.isAppUpdate} />

        {/* 组队开宝箱 */}
        {treasure_stage === 1 && (
          <TreasureBox
            isAppUpdate={this.state.isAppUpdate}
            getRemovable={this.getRemovable}
          />
        )}

        {/* 课程 */}
        <YearCourse
          stage={activity_stage}
          treasureStage={treasure_stage}
          isAppUpdate={this.state.isAppUpdate}
        />

        {/*好友加入队伍提醒；获得宝箱提醒；开售提醒弹窗，需要自取，注意修改文案*/}
        {this.state.showMark && (
          <CommonPopup top={50} closePopup={this.closePopup} mark={true}>
            <div className="sub__code_container">
              <p className="sub__title">提醒服务</p>
              <p className="sub__tip">有好友加入队伍后第一时间通知我~</p>
              <img
                className="sub__qr_code"
                id={"live-qr-code"}
                src="//cdn.julyedu.com/2018christyear/h5/qrcode.jpg"
                alt=""
              />
              <p className="sub__tip">
                长按识别/扫码 关注【七月在线】服务号即可预约
              </p>
            </div>
          </CommonPopup>
        )}

        {/*规则弹窗*/}
        {this.state.showMark && (
          <CommonPopup top={50} closePopup={this.closePopup} mark={true}>
            <div className="sub__code_container">
              <p className="sub__title">组队开宝箱活动规则</p>
              <p className="sub__rule">
                1. 活动期间（12月18日-12月31日）可随时参与开宝箱；
                <br />
                2. 当前队伍满员后可继续创建新队伍；
                <br />
                3. 每人有一次机会加入好友的队伍；
                <br />
                4. 队伍满员后所有成员均可随机获得宝箱内奖品，队长奖励更丰厚哦~
                <br />
                5.
                代金券、课程等虚拟奖品将直接发放至账户，实物奖品活动结束后统一邮寄；
                <br />
                6. 现金可提现：我的 → 赚奖学金 → 提现。
              </p>
            </div>
          </CommonPopup>
        )}

        <div className={"btm-rule"}>
          * 本活动解释权归北京七月在线科技有限公司所有 *
        </div>
      </div>
    )
  }
}

export default index
