import React, { Component } from "react"
import { Switch, Route } from "react-router-dom"
import Anniversary2020 from "src/components/activity/2020-717/activity"
import Question from "src/components/activity/2020-717/question"
import Invitation from "src/components/activity/2020-717/invitation"

class Anniversary2020Entry extends Component {
  componentDidMount() {
    document.title =
      "7.17 五周年庆，AI好课1分起购，答题、购课100%有奖！华为P40 Pro+，课程免单等你来！--七月在线"
  }

  render() {
    const match = this.props.match
    return (
      <Switch>
        <Route
          path={`${match.path}/question/:isPractice?`}
          render={(routeProps) => <Question {...routeProps}></Question>}
        ></Route>
        <Route
          path={`${match.path}/invitation`}
          render={(routeProps) => <Invitation {...routeProps} />}
        ></Route>
        <Route
          path={"/anniversary_2020"}
          render={(routeProps) => (
            <Anniversary2020 {...routeProps}></Anniversary2020>
          )}
        ></Route>
      </Switch>
    )
  }
}

export default Anniversary2020Entry
