import React, { Component } from "react"
import { connect } from "react-redux"
import "./index.scss"
import { http, getParam, browser, wxShare, SendMessageToApp } from "src/utils"
import { Toast } from "antd-mobile"
import jsCookie from "js-cookie"

class Invite extends Component {
  constructor(props) {
    super(props)
    this.state = {
      isWeiXin: false,
      showTip: false,
      hotValue: 0,
      hot_schedule: "",
      userList: [],
      inviteCode: "",
      isshowAppTip: false,
    }
  }

  componentWillMount() {
    let uid = jsCookie.get("uid")
    let shareuid = getParam("shareuid")
    if (uid === shareuid) {
    } else {
      if (getParam("new")) {
        this.props.history.push(
          `/activity?shareuid=${shareuid}&inviteCode=${getParam("inviteCode")}`
        )
      }
    }
    this.distinguishVersion()
  }

  distinguishVersion = () => {
    // plat_form 1ios 2android
    // version  1->3.704    2->4.5.1.20191105
    // eslint-disable-next-line eqeqeq
    if (getParam("plat_form") == 1) {
      let version = Number(getParam("version"))
      this.setState({
        isshowAppTip: version < 3.704,
      })
    }
    // eslint-disable-next-line eqeqeq
    if (getParam("plat_form") == 2) {
      let version = getParam("version").replace(/\./g, "").slice(0, 3)
      this.setState({
        isshowAppTip: Number(version) < 451,
      })
    }
  }

  componentDidMount() {
    if (!this.props.user.hasError) {
      this.getUserList()
      this.getHotValue()
      this.getInviteCode()
    }
  }

  componentWillReceiveProps(nextProps) {
    console.log("componentWillReceiveProps")
    if (!nextProps.user.hasError) {
      this.getUserList()
      this.getHotValue()
      this.getInviteCode()
    }
  }

  getUserList = () => {
    http.get(`${API.home}/sys/user/invite/list`).then((res) => {
      let { code, data, msg } = res.data
      if (code === 200) {
        this.setState({
          userList: data,
        })
      } else {
        Toast.info(msg, 2)
      }
    })
  }

  getHotValue = () => {
    http.get(`${API.home}/sys/user/hot/value`).then((res) => {
      let { code, data, msg } = res.data
      if (code === 200) {
        this.setState({
          hot_schedule: data.hot_schedule,
          hotValue: data.hot_value,
        })
      } else {
        Toast.info(msg, 2)
      }
    })
  }

  getInviteCode = () => {
    http.get(`${API.home}/sys/user/invite/link`).then((res) => {
      let { code, data, msg } = res.data
      if (code === 200) {
        let inviteCode = data.blessing_invite_code
        if (browser.isWeixin) {
          wxShare({
            title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
            desc:
              "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
            link: encodeURI(
              window.location.origin +
                `/invite?shareuid=${jsCookie.get(
                  "uid"
                )}&new=1&inviteCode=${inviteCode}`
            ),
            imgUrl:
              "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
          })
        }
        this.setState(() => ({
          inviteCode: inviteCode,
        }))
      } else if (code === 4030 || code === 4040) {
        this.props.history.push("/passport")
      } else {
        Toast.info(msg, 2)
      }
    })
  }

  inviteFriends = () => {
    const { user, history } = this.props
    const { inviteCode, isshowAppTip } = this.state
    // 未登录先去登录
    if (getParam("version")) {
      if (user.hasError) {
        SendMessageToApp("toLogin")
      } else {
        if (isshowAppTip) {
          Toast.info("请前往h5/pc端使用该功能", 2)
        } else {
          let data = {
            title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
            desc:
              "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
            link:
              API.m +
              `/invite?shareuid=${jsCookie.get(
                "uid"
              )}&new=1&inviteCode=${inviteCode}`,
            imgUrl:
              "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
          }
          SendMessageToApp("toShare", data)
        }
      }
    } else {
      if (user.hasError) {
        history.push("/passport")
      } else {
        if (browser.isWeixin) {
          history.push(
            `/invite?shareuid=${jsCookie.get(
              "uid"
            )}&new=1&inviteCode=${inviteCode}`
          )
          wxShare({
            title: "AI充电节，积福气享1折秒课，超10万元奖品来就送！！",
            desc:
              "把这门超5万人报名的【Python基础入门 升级版】课程送给你，附200元红包，请笑纳！--七月在线",
            link: encodeURI(
              window.location.origin +
                `/invite?shareuid=${jsCookie.get(
                  "uid"
                )}&new=1&inviteCode=${inviteCode}`
            ),
            imgUrl:
              "https://cdn.julyedu.com/active19_1111/m/index-share-img.png",
          })
          this.setState({
            showTip: true,
            isWeiXin: true,
          })
        } else {
          history.push(
            `/invite?shareuid=${jsCookie.get(
              "uid"
            )}&new=1&inviteCode=${inviteCode}`
          )
          this.setState({
            showTip: true,
          })
        }
      }
    }
  }

  closeMark = () => {
    this.setState({
      showTip: false,
    })
  }

  render() {
    let { userList, showTip, hotValue, hot_schedule, isWeiXin } = this.state
    return (
      <div className="activity__con">
        <div className="banner__con"></div>
        <div className="invite__content">
          <div className="content__one">
            <p>邀请好友注册，每增加1人可</p>
            <div className="img__con"></div>
          </div>

          <div className="content__two">福气值越高，中奖概率越大！</div>

          <div className="box__out">
            <div className="box__middle">
              <div className="box__inner">
                <p>当前中奖概率值:</p>
                <p className="hot__value">{hotValue}</p>
                <div className="hot__progress">
                  <div className="progress__bar">
                    <div
                      className="progress__point"
                      style={{ width: hot_schedule }}
                    ></div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div className="but__con">
            <div className="button__content" onClick={this.inviteFriends}>
              立即邀请
            </div>
          </div>

          {userList.length > 0 ? (
            <>
              <div className="list__title">
                <span>邀请好友列表</span>
              </div>

              <p className="show__new">(仅显示新用户)</p>
            </>
          ) : null}

          {userList.length > 0 ? (
            <div className="list__con">
              {userList.length === 1 &&
                userList.map((item, index) => {
                  return (
                    <div className="user__item-info item__con-only" key={index}>
                      <div className="item__con">
                        <img
                          className="user_avatar"
                          alt={item.user_name}
                          src={item.head_image}
                        />
                        <div className="user_name">{item.user_name}</div>
                      </div>
                    </div>
                  )
                })}

              {userList.length > 1 &&
                userList.map((item, index) => {
                  return (
                    <div className="user__item-info" key={index}>
                      <div className="item__con">
                        <img
                          className="user_avatar"
                          alt={item.user_name}
                          src={item.head_image}
                        />
                        <div className="user_name">{item.user_name}</div>
                      </div>
                    </div>
                  )
                })}
            </div>
          ) : null}
        </div>
        {showTip && (
          <div className="share__mark" onClick={this.closeMark}>
            <div className="share__tip">立即分享给好友增加中奖概率</div>
            {isWeiXin ? <div className="share__row"></div> : null}
          </div>
        )}
      </div>
    )
  }
}

export default connect((state) => ({ user: state.user }), null)(Invite)
