Object.defineProperty(exports, "__esModule", {
  value: true,
})

var _animateTypes = require("./animateTypes")

var animateTypess = _interopRequireWildcard(_animateTypes)

var clientWidth = (exports.clientWidth =
  document.documentElement.clientWidth || document.body.clientWidth)

function _interopRequireWildcard(obj) {
  if (obj && obj.__esModule) {
    return obj
  } else {
    var newObj = {}
    if (obj != null) {
      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key))
          newObj[key] = obj[key]
      }
    }
    newObj.default = obj
    return newObj
  }
}

exports.default = function (animateTypes, stage, progress, duration) {
  switch (animateTypes) {
    case animateTypess.CARD:
      switch (stage) {
        case "pre":
          return {
            width: "90%",
            left: "20px",
            transform:
              "translateX(" +
              -(clientWidth * 0.92 + progress) +
              "px) scaleY(" +
              (0.92 + Math.abs((progress / (clientWidth * 0.92)) * 0.2)) +
              ")",
            transitionDuration: duration + "s",
            zIndex: 2,
          }
        case "active":
          return {
            width: "90%",
            left: "20px",
            transform:
              "translateX(" +
              -progress +
              "px) scaleY(" +
              (1 - Math.abs((progress / (clientWidth * 0.85)) * 0.2)) +
              ")",
            transitionDuration: duration + "s",
            zIndex: 3,
          }
        case "next":
          return {
            width: "90%",
            left: "20px",
            transform:
              "translateX(" +
              (clientWidth * 0.92 - progress) +
              "px) scaleY(" +
              (0.92 + Math.abs((progress / (clientWidth * 0.92)) * 0.2)) +
              ")",
            transitionDuration: duration + "s",
            zIndex: 1,
          }
        case "prePro":
          return {
            width: "90%",
            left: "20px",
            transform:
              "translateX(" +
              (-(clientWidth * 1.7) - progress) +
              "px) scaleY(" +
              (1 - Math.abs((progress / (clientWidth * 0.92)) * 0.2)) +
              ")",
            transitionDuration: duration + "s",
            zIndex: 1,
          }
        case "nextPro":
          return {
            width: "90%",
            left: "20px",
            transform:
              "translateX(" +
              (clientWidth * 1.7 - progress) +
              "px) scaleY(" +
              (1 - Math.abs((progress / (clientWidth * 0.92)) * 0.2)) +
              ")",
            transitionDuration: duration + "s",
            zIndex: 1,
          }
        default:
          break
      }
      break
    default:
      break
  }
}
