import React from "react"
function format(content) {
  if (content) {
    if (content.includes("<img")) {
      content = content.replace(/<img/g, "<img style='width: 100%'")
    }
    content = content.replace(/&lt;/g, "<")
    content = content.replace(/&gt;/g, ">")
    content = content.replace(/&amp;gt;/g, "")
    content = content.replace(/&quot;/g, '"')
    content = content.replace(/&amp;nbsp;/g, "")
  }
  return content
}

function Header(props) {
  return (
    <div className="camp-test-header layout-flex-between">
      <div>
        <i
          onClick={props.close}
          className={"iconfont iconiconfront-77 icon-close"}
        />
      </div>
      <div className="layout-flex-center camp-test-time">
        <i className="icon icon-clock" />
        <span>{props.time}</span>
      </div>
      <div
        onClick={props.showCardEve}
        className={`icon icon-order ${props.showCard ? "no_height" : ""}`}
      />
    </div>
  )
}

function CampTitle(props) {
  return (
    <div className="layout-flex-between camp-test-title">
      <div className="qtitle">{`课后练习：${props.qtitle}`}</div>
      <div className="qnumber">{`${props.questionIndex}/${props.examList.length}`}</div>
    </div>
  )
}

function TestItem(props) {
  let { questionIndex, currentExam, currentQuestionOption } = props
  return (
    <div className="test-item-container">
      <div
        className="ques item-title"
        dangerouslySetInnerHTML={{
          __html: `${questionIndex}.${format(currentExam.ques)}`,
        }}
      />
      <ul>
        {currentExam.options &&
          currentExam.options.map((item, index) => {
            return (
              <li
                key={index}
                onClick={() => props.checkOption(item)}
                className={`
                                        ${
                                          currentQuestionOption === item.opt_id
                                            ? "option_checked"
                                            : ""
                                        }
                                        ${
                                          (currentExam.user_answer === 0 ||
                                            currentExam.user_answer) &&
                                          currentExam.user_answer ===
                                            item.opt_id
                                            ? "user_check"
                                            : ""
                                        }
                                        ${
                                          (currentExam.user_answer === 0 ||
                                            currentExam.user_answer) &&
                                          currentExam.answer_id === item.opt_id
                                            ? "right_check"
                                            : ""
                                        }
                                    `}
              >
                <span className="letter">
                  {String.fromCharCode(Number(index) + 65)}
                </span>
                <span
                  className="des"
                  dangerouslySetInnerHTML={{ __html: format(item.des) }}
                />
              </li>
            )
          })}
      </ul>
      {props.children}
    </div>
  )
}

function ChangeQuestion(props) {
  return (
    <div className={"layout-flex-around change_question_container"}>
      <div
        onClick={props.preQuestion}
        className={`change_button pre_question ${
          props.questionIndex === 1 ? "first_question" : ""
        }`}
      >
        上一题
      </div>
      <div
        onClick={props.nextQuestion}
        className={`change_button next_question`}
      >
        下一题
      </div>
    </div>
  )
}

function Resolve(props) {
  let { currentExam } = props
  let Test = currentExam.compare === 0 ? "错误" : "正确"
  let UserIndex, rightIndex
  currentExam.options.forEach((item, index) => {
    if (currentExam.answer_id === item.opt_id) {
      rightIndex = index
    }
    if (
      currentExam.user_answer !== 0 &&
      currentExam.user_answer === item.opt_id
    ) {
      UserIndex = (
        <span>{`您的答案是${String.fromCharCode(Number(index) + 65)}，`}</span>
      )
    }
  })
  if (currentExam.user_answer === 0) {
    UserIndex = <span>{`您的答案是空，`}</span>
  }
  return (
    <div className={"test-resolve"}>
      <div className={"isRight"}>
        <span>{`正确答案是${String.fromCharCode(
          Number(rightIndex) + 65
        )}，`}</span>
        {UserIndex}
        <span>{`回答${Test}。`}</span>
      </div>
      <p>解析</p>
      <div
        className={"resolve-content"}
        dangerouslySetInnerHTML={{ __html: `${format(currentExam.analysis)}` }}
      />
    </div>
  )
}

export { Header, CampTitle, TestItem, ChangeQuestion, Resolve }
