import React, { Component } from "react"
import { Checkbox } from "antd-mobile"
import OrderList from "src/common/OrderList"

class CartItem extends Component {
  // 构造函数
  constructor(props) {
    super(props)
    this.state = {
      val: props.item.value,
    }
  }
  // 改变选择
  onChange(e, id) {
    let checked = e.target.checked
    this.props.checkChange(id, checked)
  }

  render() {
    let item = this.props.item
    const Info = (
      <div className="order-info">
        <p
          className="order-title text-overflow-one"
          onClick={() => this.props.toDetail(item.course_id)}
        >
          {/* <Link to={`/detail?id=${item.course_id}`}> */}
          {item.course_title}
          {/* </Link> */}
        </p>
        <p className="order-content text-overflow-2">
          {item.simpledescription}
        </p>
        <p className="order-des">
          <span className="order-newprice">¥{item.price1}</span>
          <span className="order-price">¥{item.price0}</span>
        </p>
      </div>
    )

    return (
      <div className="cart-c-item">
        <div className="cart-c-check">
          <Checkbox
            checked={item.check}
            onChange={(e) => {
              this.onChange(e, item.course_id)
            }}
          />
        </div>

        <div className="card-wrap">
          <OrderList
            info={Info}
            src={item.image_name}
            id={item.course_id}
            toDetail={this.props.toDetail}
          ></OrderList>
        </div>
      </div>
    )
  }
}
export default CartItem
