import React, { Component } from "react"
import "./index.scss"
import { CallApp } from "./../../../common"

export default class Poup extends Component {
  render() {
    return (
      <div className={"mask_container"}>
        <div className={"content"}>
          <p className={"title"}>温馨提示</p>
          {this.props.type === 1 ? (
            <>
              <p className={"tip"}>
                当前环境暂不支持该课程模式，您可前往七月在线PC端或者APP体验课程。
              </p>
              <CallApp
                className="btn btn-18B4ED"
                text={"前往APP体验课程"}
              ></CallApp>
            </>
          ) : (
            <>
              <p className={"tip"}>
                当前环境暂不支持该课程模式，您可前往七月在线PC端或者APP学习课程。
              </p>
              <CallApp
                className="btn btn-18B4ED"
                text={"前往APP学习课程"}
              ></CallApp>
            </>
          )}
          <img
            onClick={this.props.closePop}
            className={"close_btn"}
            src="https://cdn.julyedu.com/h5_python_class/bottom_close.png"
            alt=""
          />
        </div>
      </div>
    )
  }
}
