import React, { Component } from "react"
import ReactDom from "react-dom"

import "./overlay.scss"

const root = document.body || document.documentElement

const events = ["touchmove", "mousewheel"]

class Overlay extends Component {
  constructor(props) {
    super(props)
    this.overlayBox = null
  }

  preventScroll = (e) => {
    e.preventDefault()
  }

  componentDidMount() {
    events.forEach((item) => {
      this.overlayBox.addEventListener(item, this.preventScroll, {
        passive: false,
      })
    })
  }

  componentWillUnmount() {
    events.forEach((item) => {
      this.overlayBox.removeEventListener(item, this.preventScroll)
    })
  }

  render() {
    return ReactDom.createPortal(
      <div
        className={"overlay"}
        ref={(el) => (this.overlayBox = el)}
        style={{ top: `${window.scrollY}px` }}
      >
        {this.props.children}
      </div>,
      root
    )
  }
}

export default Overlay
