import React, { Component } from "react"
import { Toast } from "antd-mobile"
import { http } from "src/utils"
import "./confirm.scss"

class BargainConfirmBind extends Component {
  farmatKey = (key) => {
    let data = null
    switch (key) {
      case 1:
        data = {
          key: "email",
          type: "email",
        }
        break
      case 2:
        data = {
          key: "wechat_nickname",
          type: "wechat",
        }
        break
      case 3:
        data = {
          key: "qq_nickname",
          type: "qq",
        }
        break
      case 4:
        data = {
          key: "sina_nickname",
          type: "sina",
        }
        break
      default:
        data = null
        break
    }
    return data
  }

  confirmBindPhone = () => {
    const { data, handleToBargain } = this.props

    // is_valid	是否验证 1:验证（默认）,0不验证
    http
      .post(`${API["passport-api"]}/m/personal/bindPhone`, {
        ...data,
        type: 1,
        is_valid: 0,
      })
      .then((res) => {
        const { errno, msg } = res.data
        if (errno === 200) {
          handleToBargain()
        } else {
          Toast.info(msg)
        }
      })
  }

  render() {
    const { bindInfo, handleToHide } = this.props
    return (
      <div className="bargain-bind-confirm">
        <h4 className="bargain-bind-confirm__title">绑定确认</h4>
        <p className="bargain-bind-confirm__desc">
          该手机号已绑定到以下账号，继续绑定将解除以下绑定状态
        </p>
        <ul className="bargain-bind-confirm__list">
          {bindInfo &&
            [1, 2, 3, 4].map((item) => {
              const data = this.farmatKey(item)
              if (bindInfo[data.key]) {
                return (
                  <li className="bargain-bind-confirm__account" key={item}>
                    <i
                      className="bargain-bind-confirm__icon"
                      data-plat={data.type}
                    ></i>
                    <p className="bargain-bind-confirm__name">
                      {bindInfo[data.key]}
                    </p>
                  </li>
                )
              }
              return null
            })}
        </ul>
        <div className="bargain-bind-confirm__footer">
          <button
            className="bargain-bind-confirm__button"
            data-type="cancle"
            onClick={handleToHide}
          >
            取消
          </button>
          <button
            className="bargain-bind-confirm__button"
            data-type="confirm"
            onClick={this.confirmBindPhone}
          >
            继续绑定
          </button>
        </div>
      </div>
    )
  }
}

export default BargainConfirmBind
