import React, { Component } from "react"
import "./input.scss"

import classnames from "classnames"

class Input extends Component {
  constructor(props) {
    super(props)
    this.state = {
      isFocus: false,
    }
  }

  clearInput = () => {
    this.props.onChange("")
  }

  render() {
    let { type, placeholder } = this.props
    const { isFocus } = this.state
    return (
      <div className="custom-input-wrapper">
        <input
          type={type}
          className={classnames("custom-input", {
            "custom-input--active": isFocus,
          })}
          placeholder={placeholder}
          onChange={this.props.onChange}
          value={this.props.value}
          onBlur={() => {
            this.setState({
              isFocus: false,
            })
          }}
          onFocus={() => {
            this.setState({
              isFocus: true,
            })
          }}
        />
        <i
          className={classnames("iconfont icondanseshixintubiao-3", {
            hide: this.props.value.length === 0,
          })}
          onClick={this.clearInput}
        />
      </div>
    )
  }
}

Input.defaultProps = { type: "text", placeholder: "" }

export default Input
