import React, { Component } from "react"
import classnames from "classnames"
import "./index.scss"

class ListHeader extends Component {
  render() {
    const { text, size, styles, id } = this.props
    const cls = size ? `list-header--${size}` : ""
    return (
      <div id={id} className={classnames("list-header", cls)} style={styles}>
        <i className="list-header__decorate" data-position="left"></i>
        {text ? (
          <h2 className="list-header__content">{text}</h2>
        ) : (
          this.props.children
        )}
        <i className="list-header__decorate" data-position="right"></i>
      </div>
    )
  }
}

export default ListHeader
