/* eslint-disable jsx-a11y/anchor-is-valid */
import React, { Component } from "react"
import classnames from "classnames"
import { http, getParam, SendMessageToApp } from "src/utils"
import { Toast } from "antd-mobile"
import ListFrame from "./../listFrame/index"
import CourseItem from "./../courseItem/index"
import ListHeader from "./../listHeader"
import "./index.scss"

class CourseList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      basic: {
        course: [],
        courseList: [],
        isMore: false,
      },
      advanced: {
        course: [],
        courseList: [],
        isMore: false,
      },
      higher: {
        course: [],
        courseList: [],
        isMore: false,
      },
      expand: {
        course: [],
        courseList: [],
        isMore: false,
      },
      group: {
        course: [],
        courseList: [],
        isMore: false,
      },
      training: {
        course: [],
        courseList: [],
        isMore: false,
      },
    }
  }

  componentDidMount() {
    // 精品课程-集训营、就业班/AI特训营
    this.fetchCourseData()

    // AI之路-基础
    this.fetchAICourse("one")

    // AI之路-进阶
    this.fetchAICourse("two")

    // AI之路-高阶
    this.fetchAICourse("three")

    // AI之路-拓展
    this.fetchAICourse("four")
  }

  shouldComponentUpdate(nextProps, nextState, nextContext) {
    if (this.props.isApp !== nextProps.isApp) {
      // 精品课程-集训营、就业班/AI特训营
      this.fetchCourseData()

      // AI之路-基础
      this.fetchAICourse("one")

      // AI之路-进阶
      this.fetchAICourse("two")

      // AI之路-高阶
      this.fetchAICourse("three")

      // AI之路-拓展
      this.fetchAICourse("four")
      return false
    }
    return true
  }

  fetchAICourse = (key) => {
    const { basic, advanced, higher, expand } = this.state
    http.get(`${API.home}/sys/ai_grow_up_courses/${key}`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        if (data.length > 4) {
          if (key === "one") {
            this.setState({
              basic: Object.assign({}, basic, {
                isMore: true,
                course: data.filter((item, index) => index < 4),
                courseList: data,
              }),
            })
          }
          if (key === "two") {
            this.setState({
              advanced: Object.assign({}, advanced, {
                isMore: true,
                course: data.filter((item, index) => index < 4),
                courseList: data,
              }),
            })
          }
          if (key === "three") {
            this.setState({
              higher: Object.assign({}, higher, {
                isMore: true,
                course: data.filter((item, index) => index < 4),
                courseList: data,
              }),
            })
          }
          if (key === "four") {
            this.setState({
              expand: Object.assign({}, expand, {
                isMore: true,
                course: data.filter((item, index) => index < 4),
                courseList: data,
              }),
            })
          }
        } else {
          if (key === "one") {
            this.setState({
              basic: Object.assign({}, basic, {
                isMore: false,
                course: data,
                courseList: data,
              }),
            })
          }
          if (key === "two") {
            this.setState({
              advanced: Object.assign({}, advanced, {
                isMore: false,
                course: data,
                courseList: data,
              }),
            })
          }
          if (key === "three") {
            this.setState({
              higher: Object.assign({}, higher, {
                isMore: false,
                course: data,
                courseList: data,
              }),
            })
          }
          if (key === "four") {
            this.setState({
              expand: Object.assign({}, expand, {
                isMore: false,
                course: data,
                courseList: data,
              }),
            })
          }
        }
      }
    })
  }

  fetchCourseData = () => {
    const { group, training } = this.state
    http.get(`${API.home}/sys/preheat_data`).then((res) => {
      const { code, data } = res.data
      if (code === 200) {
        if (data.excellent_course.length > 2) {
          this.setState({
            group: Object.assign({}, group, {
              isMore: true,
              course: data.excellent_course.filter((item, index) => index < 2),
              courseList: data.excellent_course,
            }),
          })
        } else {
          this.setState({
            group: Object.assign({}, group, {
              isMore: false,
              course: data.excellent_course,
              courseList: data.excellent_course,
            }),
          })
        }
        if (data.ai_elite_courses.length > 2) {
          this.setState({
            training: Object.assign({}, training, {
              isMore: true,
              course: data.ai_elite_courses.filter((item, index) => index < 2),
              courseList: data.ai_elite_courses,
            }),
          })
        } else {
          this.setState({
            training: Object.assign({}, training, {
              isMore: false,
              course: data.ai_elite_courses,
              courseList: data.ai_elite_courses,
            }),
          })
        }
      }
    })
  }

  handleToMore = (key) => {
    let data = {}
    if (this.state[key]["isMore"]) {
      data[key] = {
        isMore: !this.state[key]["isMore"],
        course: this.state[key]["courseList"],
        courseList: this.state[key]["courseList"],
      }
      this.setState({
        ...data,
      })
    } else {
      if (key === "group" || key === "training") {
        data[key] = {
          isMore: !this.state[key]["isMore"],
          course: this.state[key]["courseList"].filter(
            (item, index) => index < 2
          ),
          courseList: this.state[key]["courseList"],
        }
      } else {
        data[key] = {
          isMore: !this.state[key]["isMore"],
          course: this.state[key]["courseList"].filter(
            (item, index) => index < 4
          ),
          courseList: this.state[key]["courseList"],
        }
      }
      this.setState({
        ...data,
      })
    }
  }

  toReceiveCoupon(id, key = "") {
    const { isLogin, toLogin } = this.props

    if (isLogin) {
      var _czc = _czc || []
      var name = "课程id=" + id
      _czc.push(["_trackEvent", name, "m端双十一立即领券"])

      http
        .post(`${API.home}/sys/activity/coupon/receive`, {
          course_id: id,
        })
        .then((res) => {
          const { code, msg } = res.data
          if (code === 200) {
            Toast.info("领取成功～", 2, null, false)
            let obj = {}
            obj[key] = {
              isMore: this.state[key]["isMore"],
              course: this.state[key]["course"].map((item) => {
                if (item.course_id === id) {
                  return Object.assign({}, item, {
                    course_status: 2,
                  })
                }
                return item
              }),
              courseList: this.state[key]["courseList"].map((item) => {
                if (item.course_id === id) {
                  return Object.assign({}, item, {
                    course_status: 2,
                  })
                }
                return item
              }),
            }
            this.setState({
              ...obj,
            })
          } else {
            Toast.info(msg, 2, null, false)
          }
        })
    } else {
      toLogin()
    }
  }

  toQQque = () => {
    if (!getParam("version")) {
      window.location.href = "https://q.url.cn/AB8aue?_type=wpa&qidian=true"
    } else {
      SendMessageToApp("toQQ", "https://q.url.cn/AB8aue?_type=wpa&qidian=true")
    }
  }

  // 去课程详情页
  toCourse = (courseId) => {
    const { history } = this.props
    if (!getParam("version")) {
      history.push(`/detail?id=${courseId}`)
    } else {
      SendMessageToApp("toCourse", courseId)
    }
  }

  // 开始使用
  toCourse2 = (courseId) => {
    const { history } = this.props
    var _czc = window._czc || []
    var name = "课程id=" + courseId
    _czc.push(["_trackEvent", name, "m端双十一开始使用优惠券"])

    if (!getParam("version")) {
      history.push(`/detail?id=${courseId}`)
    } else {
      SendMessageToApp("toCourse", courseId)
    }
  }

  render() {
    const { isFormal } = this.props
    const { basic, advanced, higher, expand, group, training } = this.state
    return (
      <div className="boutique-course">
        <ListHeader
          text="集训营、就业班"
          size="middle"
          styles={{ margin: "20px 0 15px" }}
        />
        {/* 集训营、就业班 */}
        {group.course && group.course.length > 0 && (
          <>
            <div data-layout="row">
              {group.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  <div className="coupon-course__footer">
                    <a onClick={() => this.toQQque()} className="course-button">
                      立抢超低团购价
                    </a>
                  </div>
                </CourseItem>
              ))}
            </div>
            {group.courseList && group.courseList.length > 2 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("group")}
              >
                {group.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}

        <ListHeader
          text="AI特训营"
          size="middle"
          styles={{ margin: "0 0 15px" }}
        />
        {/* AI特训营 */}
        {training.course && training.course.length > 0 && (
          <>
            <div data-layout="row">
              {training.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  <div className="coupon-course__footer">
                    {item.course_status === 1 && (
                      <a
                        className={classnames(
                          "coupon-course__button",
                          "coupon-course__button--receive"
                        )}
                        onClick={() =>
                          this.toReceiveCoupon(item.course_id, "training")
                        }
                      >
                        <span className="coupon-course__button-price">
                          <em>¥{item.coupon}</em>
                          <i>代金券</i>
                        </span>
                        <span className="coupon-course__button-label">
                          立即领券
                        </span>
                      </a>
                    )}

                    {isFormal === 0 && item.course_status === 2 && (
                      <a className="coupon-course__button">
                        <span className="coupon-course__button-price">
                          <em>¥{item.coupon}</em>
                          <i>代金券</i>
                        </span>
                        <span className="coupon-course__button-label">
                          11.11开始使用
                        </span>
                      </a>
                    )}
                    {isFormal === 1 && item.course_status === 2 && (
                      <a
                        onClick={() => this.toCourse2(item.course_id)}
                        className="coupon-course__button"
                      >
                        <span className="coupon-course__button-price">
                          <em>¥{item.coupon}</em>
                          <i>代金券</i>
                        </span>
                        <span className="coupon-course__button-label">
                          开始使用
                        </span>
                      </a>
                    )}
                    {item.course_status === 3 && (
                      <a
                        onClick={() => this.toCourse(item.course_id)}
                        className="course-button"
                        data-type="study"
                      >
                        开始学习
                      </a>
                    )}
                  </div>
                </CourseItem>
              ))}
            </div>
            {training.courseList && training.courseList.length > 2 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("training")}
              >
                {training.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}

        {/* AI成长之路--基础 */}
        <ListHeader
          text="AI成长之路"
          size="middle"
          styles={{ margin: "0 0 15px" }}
        />
        {basic.course && basic.course.length > 0 && (
          <>
            <h4 className="ai-course__subtitle">基础</h4>
            <div data-layout="row">
              {basic.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  {item.type === 0 && (
                    <div className="coupon-course__footer">
                      {item.course_status === 1 && (
                        <a
                          className={classnames(
                            "coupon-course__button",
                            "coupon-course__button--receive"
                          )}
                          onClick={() =>
                            this.toReceiveCoupon(item.course_id, "basic")
                          }
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            立即领券
                          </span>
                        </a>
                      )}

                      {isFormal === 0 && item.course_status === 2 && (
                        <a className="coupon-course__button">
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            11.11开始使用
                          </span>
                        </a>
                      )}
                      {isFormal === 1 && item.course_status === 2 && (
                        <a
                          onClick={() => this.toCourse2(item.course_id)}
                          className="coupon-course__button"
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            开始使用
                          </span>
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                  {item.type === 1 && (
                    <div className="cent-course__footer">
                      {(item.course_status === 1 ||
                        item.course_status === 2) && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                        >
                          1分钱开团
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                </CourseItem>
              ))}
            </div>
            {basic.courseList && basic.courseList.length > 4 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("basic")}
              >
                {basic.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}

        {/* AI成长之路--进阶 */}
        {advanced.course && advanced.course.length > 0 && (
          <>
            <h4 className="ai-course__subtitle">进阶</h4>
            <div data-layout="row">
              {advanced.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  {item.type === 0 && (
                    <div className="coupon-course__footer">
                      {item.course_status === 1 && (
                        <a
                          className={classnames(
                            "coupon-course__button",
                            "coupon-course__button--receive"
                          )}
                          onClick={() =>
                            this.toReceiveCoupon(item.course_id, "advanced")
                          }
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            立即领券
                          </span>
                        </a>
                      )}
                      {isFormal === 0 && item.course_status === 2 && (
                        <a className="coupon-course__button">
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            11.11开始使用
                          </span>
                        </a>
                      )}
                      {isFormal === 1 && item.course_status === 2 && (
                        <a
                          onClick={() => this.toCourse2(item.course_id)}
                          className="coupon-course__button"
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            开始使用
                          </span>
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                  {item.type === 1 && (
                    <div className="cent-course__footer">
                      {(item.course_status === 1 ||
                        item.course_status === 2) && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                        >
                          1分钱开团
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                </CourseItem>
              ))}
            </div>
            {advanced.courseList && advanced.courseList.length > 4 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("advanced")}
              >
                {advanced.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}

        {/* AI成长之路--高阶 */}
        {higher.course && higher.course.length > 0 && (
          <>
            <h4 className="ai-course__subtitle">高阶</h4>
            <div data-layout="row">
              {higher.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  {item.type === 0 && (
                    <div className="coupon-course__footer">
                      {item.course_status === 1 && (
                        <a
                          className={classnames(
                            "coupon-course__button",
                            "coupon-course__button--receive"
                          )}
                          onClick={() =>
                            this.toReceiveCoupon(item.course_id, "higher")
                          }
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            立即领券
                          </span>
                        </a>
                      )}
                      {isFormal === 0 && item.course_status === 2 && (
                        <a className="coupon-course__button">
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            11.11开始使用
                          </span>
                        </a>
                      )}
                      {isFormal === 1 && item.course_status === 2 && (
                        <a
                          onClick={() => this.toCourse2(item.course_id)}
                          className="coupon-course__button"
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            开始使用
                          </span>
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                  {item.type === 1 && (
                    <div className="cent-course__footer">
                      {(item.course_status === 1 ||
                        item.course_status === 2) && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                        >
                          1分钱开团
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                </CourseItem>
              ))}
            </div>
            {higher.courseList && higher.courseList.length > 4 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("higher")}
              >
                {higher.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}

        {/* AI成长之路--扩展 */}
        {expand.course && expand.course.length > 0 && (
          <>
            <h4 className="ai-course__subtitle">扩展</h4>
            <div data-layout="row">
              {expand.course.map((item) => (
                <CourseItem
                  image={item.image_name}
                  key={item.course_id}
                  id={item.course_id}
                  toCourse={this.toCourse}
                >
                  {item.type === 0 && (
                    <div className="coupon-course__footer">
                      {item.course_status === 1 && (
                        <a
                          className={classnames(
                            "coupon-course__button",
                            "coupon-course__button--receive"
                          )}
                          onClick={() =>
                            this.toReceiveCoupon(item.course_id, "expand")
                          }
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            立即领券
                          </span>
                        </a>
                      )}

                      {isFormal === 0 && item.course_status === 2 && (
                        <a className="coupon-course__button">
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            11.11开始使用
                          </span>
                        </a>
                      )}
                      {isFormal === 1 && item.course_status === 2 && (
                        <a
                          onClick={() => this.toCourse2(item.course_id)}
                          className="coupon-course__button"
                        >
                          <span className="coupon-course__button-price">
                            <em>¥{item.coupon}</em>
                            <i>代金券</i>
                          </span>
                          <span className="coupon-course__button-label">
                            开始使用
                          </span>
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                  {item.type === 1 && (
                    <div className="cent-course__footer">
                      {(item.course_status === 1 ||
                        item.course_status === 2) && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                        >
                          1分钱开团
                        </a>
                      )}
                      {item.course_status === 3 && (
                        <a
                          onClick={() => this.toCourse(item.course_id)}
                          className="course-button"
                          data-type="study"
                        >
                          开始学习
                        </a>
                      )}
                    </div>
                  )}
                </CourseItem>
              ))}
            </div>
            {expand.courseList && expand.courseList.length > 4 && (
              <button
                className="more-button"
                onClick={() => this.handleToMore("expand")}
              >
                {expand.isMore ? "展开更多" : "收起"}
              </button>
            )}
          </>
        )}
      </div>
    )
  }
}

export default ListFrame(CourseList)
