import React from "react"
import "./index.scss"
import classnames from "classnames"

const Navigation = ({ questions, answer, handleClick, isAnalysis }) => {
  return (
    <div className="navigation">
      <ul>
        {!!questions.length &&
          questions.map((item, index) => {
            const userSelectIndex = item.options.findIndex(
              (item) => item.user_select
            )
            const rightAnswerIndex = item.options.findIndex(
              (item) => item.is_ans
            )
            return (
              <li
                key={index}
                onClick={handleClick.bind(this, index)}
                className={classnames({
                  active: answer && answer[item.id],
                  correct: isAnalysis && userSelectIndex === rightAnswerIndex,
                  error:
                    isAnalysis &&
                    userSelectIndex >= 0 &&
                    userSelectIndex !== rightAnswerIndex,
                  unselect: isAnalysis && userSelectIndex < 0,
                })}
              >
                {index + 1}
              </li>
            )
          })}
      </ul>
    </div>
  )
}

export default Navigation
