import React, { Component } from "react"
import "./index.scss"
import { HeaderBar } from "src/common/index"
import Question from "src/components/ai-test/common/question"
import Navigation from "src/components/ai-test/common/navigation"
import { html, http } from "src/utils"
import { Toast } from "antd-mobile"
import Recommends from "src/components/ai-test/common/recommends"

class Analysis extends Component {
  state = {
    questions: [],
    activeIndex: 0,
    userSelect: "",
    rightAnswer: "",
    userUnselect: false,
  }

  componentDidMount() {
    this.getAnalysis()
  }

  getAnalysis = () => {
    http
      .post(`${API.home}/sys/get_analysis`, {
        record_id: this.props.match.params.recordId,
      })
      .then((res) => {
        const { code, msg, data } = res.data
        if (code === 200) {
          this.setState(
            {
              questions: data,
            },
            () => {
              this.getAnswerInfo()
            }
          )
        } else {
          Toast.fail(msg, 2, null, false)
        }
      })
  }

  getAnswerInfo = () => {
    const { questions, activeIndex } = this.state
    const question = questions[activeIndex]
    const userAnswerIndex = question.options.findIndex(
      (item) => item.user_select
    )
    const rightAnswerIndex = question.options.findIndex((item) => item.is_ans)
    this.setState({
      userSelect: String.fromCharCode(65 + userAnswerIndex),
      rightAnswer: String.fromCharCode(65 + rightAnswerIndex),
      userUnselect: userAnswerIndex < 0,
    })
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevState.activeIndex !== this.state.activeIndex) {
      this.getAnswerInfo()
    }
  }

  render() {
    const {
      questions,
      activeIndex,
      userSelect,
      rightAnswer,
      userUnselect,
    } = this.state
    return (
      <div className={"analysis-container"}>
        <HeaderBar title={"AI水平测试"} arrow={true} />
        {!!questions.length && (
          <Question
            activeIndex={activeIndex}
            question={questions[activeIndex]}
          />
        )}
        <div style={{ height: "8px", backgroundColor: "#f5f5f5" }}></div>
        <div className="analysis">
          {userUnselect ? (
            <div className={"info"}>您未作答</div>
          ) : (
            <div className="info">
              您选择的是{userSelect}，正确答案是{rightAnswer} 回答
              {userSelect === rightAnswer ? "正确" : "错误"}
            </div>
          )}
          <div className="content">
            <div className="head">
              <i className="icon"></i>
              <span>解析</span>
            </div>
            {!!questions.length && (
              <div
                className="analysis-content"
                dangerouslySetInnerHTML={html(questions[activeIndex].analysis)}
              ></div>
            )}
          </div>
        </div>
        {!!questions.length &&
          questions[activeIndex] &&
          questions[activeIndex].commend_course &&
          !!questions[activeIndex].commend_course.length && (
            <Recommends recommends={questions[activeIndex].commend_course} />
          )}
        <Navigation
          questions={questions}
          isAnalysis={true}
          handleClick={(index) => {
            this.setState({
              activeIndex: index,
            })
          }}
        />
      </div>
    )
  }
}

export default Analysis
