/* eslint-disable eqeqeq */
import React, { Component } from "react"
import classnames from "classnames"
import "./team.scss"
import { getParam } from "src/utils"

class TreasureTeam extends Component {
  constructor(props) {
    super(props)
    this.state = {
      team: {},
      currentMember: {},
    }
  }

  componentDidMount() {
    this.initMemberInfo()
  }

  componentWillReceiveProps(nextProps) {
    const { data: oldData } = this.props
    const { data: newData } = nextProps
    if (newData.is_open != oldData.is_open) {
      this.initMemberInfo(newData)
    }
  }

  initMemberInfo = (params = {}) => {
    const { data, userInfo } = this.props
    const arr = JSON.stringify(params) !== "{}" ? params : data
    let member = arr.member
    let len = member.length - 5
    for (; len < 0; len++) {
      member.push({})
    }
    this.setState({
      team: Object.assign({}, arr, {
        member,
      }),
      currentMember: userInfo.uid
        ? member.filter((item) => item.uid == userInfo.uid)[0]
        : {},
    })
  }

  computedClass = (id) => {
    const {
      data: { is_open },
    } = this.props
    const { currentMember } = this.state
    return classnames("team-member__item", {
      active: id === currentMember.uid && is_open,
    })
  }

  computedBg = (val) => {
    return val
      ? {
          backgroundImage: `url(${val})`,
        }
      : {}
  }

  // 查看队友的奖品，条件：宝箱已拆
  toCheckPrize = (id) => {
    const {
      team: { is_open, member = [] },
    } = this.state
    if (is_open) {
      const data = member.filter((item) => item.uid === id)
      this.setState({
        currentMember: data[0],
      })
    }
  }

  render() {
    const {
      team: {
        is_captain,
        status,
        team_num,
        lack_member,
        is_open,
        treasure_code,
        member = [],
      },
      currentMember,
    } = this.state
    const { toSplitTreasure, userInfo, children } = this.props
    return (
      <div className="team-container" data-skip="team">
        {!is_captain && <i className="team-friend">友</i>}

        {/* 组队状态 */}
        {status === 1 ? (
          <i className="team-status">组队中..</i>
        ) : (
          <i className="team-decorate"></i>
        )}

        {/* 队伍类型 */}
        {is_captain ? (
          <h2 className="team-title">{team_num}号队伍</h2>
        ) : (
          <h2 className="team-title">好友队伍</h2>
        )}

        {/* 队员情况 */}
        {status === 1 ? (
          <p className="team-desc">还差{lack_member}名队员即可获得宝箱哦～</p>
        ) : (
          <p className="team-desc">组队成功</p>
        )}
        <div className="team-member">
          {member.map((item, index) => (
            <div
              className={this.computedClass(item.uid)}
              onClick={() => this.toCheckPrize(item.uid)}
              key={index}
              style={this.computedBg(item.head_img)}
            >
              {item.is_captain && (
                <span className="team-member__captain">队长</span>
              )}
            </div>
          ))}
        </div>
        <div className="team-footer" data-layout={is_open ? "column" : "row"}>
          {/* 队伍未满 */}
          {status === 1 && (
            <>
              {getParam("version") ? (
                is_captain ? (
                  <a
                    className="team-button"
                    href={`https://m.julyedu.com/box/landing?treasure_code=${treasure_code}&origin=1&version=${getParam(
                      "version"
                    )}`}
                  >
                    继续邀请队友
                  </a>
                ) : (
                  <a
                    className="team-button"
                    href={`https://m.julyedu.com/box/landing?treasure_code=${treasure_code}&origin=2&version=${getParam(
                      "version"
                    )}`}
                  >
                    帮好友完成组队
                  </a>
                )
              ) : is_captain ? (
                <a
                  className="team-button"
                  href={`https://m.julyedu.com/box/landing?treasure_code=${treasure_code}&origin=1`}
                >
                  继续邀请队友
                </a>
              ) : (
                <a
                  className="team-button"
                  href={`https://m.julyedu.com/box/landing?treasure_code=${treasure_code}&origin=2`}
                >
                  帮好友完成组队
                </a>
              )}
            </>
          )}

          {/* 可拆状态 */}
          {status === 2 && !is_open && (
            <>
              <span className="team-icon" data-direction="left"></span>
              <span
                className="team-button--split"
                onClick={toSplitTreasure}
              ></span>
              <span className="team-icon" data-direction="right"></span>
            </>
          )}

          {/* 已拆状态 */}
          {status === 2 && is_open && (
            <>
              {currentMember.prize_name ? (
                <p className="team-prize">{currentMember.prize_name}</p>
              ) : (
                <p className="team-prize">尚未开宝箱</p>
              )}
              {currentMember.uid == userInfo.uid ? children : null}
            </>
          )}
        </div>
      </div>
    )
  }
}

export default TreasureTeam
