import React, { Component } from "react"
import "./prizes.scss"
import { http } from "src/utils"
import { Toast } from "antd-mobile"

function showToast(text) {
  Toast.info(text, 2, null, false)
}

class Prizes extends Component {
  state = {
    list: [],
    isShowRule: false,
    rule: "",
    rankList: [],
  }

  componentDidMount() {
    const { rankingList } = this.props
    if (!rankingList || !rankingList.length) {
      this.getRankingList()
    } else {
      this.setState({
        rankingList,
      })
    }
    this.getPrizes()
  }

  getPrizes = () => {
    http.get(`${API["base-api"]}/assistance/invite`).then((res) => {
      const { data, msg, errno } = res.data
      if (errno === 200) {
        this.setState({
          list: data.awards,
          rule: data.rule,
        })
      } else {
        showToast(msg)
      }
    })
  }

  getRankingList = () => {
    const { saveRankingList } = this.props
    http.get(`${API["base-api"]}/assistance/ranking_list/50`).then((res) => {
      const { data, msg, errno } = res.data
      if (errno === 200) {
        this.setState({
          rankList: data.list,
        })

        saveRankingList && saveRankingList(data.list)
      } else {
        showToast(msg)
      }
    })
  }

  render() {
    const { list, rankList, isShowRule, rule } = this.state
    return (
      <div id={"prizes"}>
        <div className="content">
          <i className="part-title__decorate" />
          <div className="part-title__txt">活动奖品</div>
          <i className="part-title__decorate" />

          <div className="prize-img">
            {list.map((item, index) => {
              return (
                <div className="img-box" key={index}>
                  <img src={item} alt="" />
                </div>
              )
            })}
          </div>

          <span
            className="rule"
            onClick={() => {
              this.setState({ isShowRule: true })
            }}
          >
            活动规则
          </span>
        </div>

        <div className="content" style={{ padding: `20px 0 30px 0` }}>
          <i className="part-title__decorate" />
          <div className="part-title__txt">排行榜</div>
          <i className="part-title__decorate" />

          <div className="tip">数据实时更新 只显示Top50</div>

          <table className="ranking" cellSpacing="0" cellPadding="0" border="0">
            <thead>
              <tr>
                <td>排名</td>
                <td>用户名称</td>
                <td>邀请人数</td>
              </tr>
            </thead>
            <tbody>
              {rankList.map((item, index) => {
                return (
                  <tr key={index}>
                    <td>{index + 1}</td>
                    <td>{item.name}</td>
                    <td>{item.num}</td>
                  </tr>
                )
              })}
            </tbody>
          </table>
        </div>

        {isShowRule ? (
          <div className="mbc-box">
            <div className="rele-content-box">
              <div className="title">活动规则</div>

              <div className="rele-content">
                <div dangerouslySetInnerHTML={{ __html: rule }}></div>
              </div>

              <img
                className="close"
                onClick={() => {
                  this.setState({ isShowRule: false })
                }}
                src="https://cdn.julyedu.com/newyear20/H5/close-btn.png"
                alt=""
              />
            </div>
          </div>
        ) : null}
      </div>
    )
  }
}

export default Prizes
