import React from "react"
import Prices from "./index"
import { withKnobs, number } from "@storybook/addon-knobs"

export default {
  title: "prices",
  component: Prices,
  decorators: [
    withKnobs,
    (story: () => React.ReactNode) => (
      <div className={"shadow"} style={{ width: "100px", padding: "10px" }}>
        {story()}
      </div>
    ),
  ],
}

export const Default = () => {
  const current = number("current", 100)
  const origin = number("origin", 1000)
  return <Prices current={current} origin={origin}></Prices>
}
